/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.web.AbstractHttpServlet;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.login.GateinWCIController;
import org.exoplatform.web.security.security.AbstractTokenService;
import org.exoplatform.web.security.security.CookieTokenService;

public class ErrorLoginServlet
extends AbstractHttpServlet {
    private static final long serialVersionUID = -1565579389217147072L;
    private static final Log LOG = ExoLogger.getLogger((String)ErrorLoginServlet.class.getName());

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        GateinWCIController wciController = new GateinWCIController(this.getServletContext());
        PortalContainer pContainer = PortalContainer.getInstance();
        ServletContext context = pContainer.getPortalContext();
        this.unregisterTokenCookie(req);
        this.clearTokenCookie(req, resp);
        resp.setContentType("text/html; charset=UTF-8");
        wciController.showErrorLoginForm(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private void clearTokenCookie(HttpServletRequest req, HttpServletResponse resp) {
        Cookie cookie = new Cookie("rememberme", "");
        cookie.setPath(req.getContextPath());
        cookie.setMaxAge(0);
        resp.addCookie(cookie);
    }

    private void unregisterTokenCookie(HttpServletRequest req) {
        String tokenId = this.getTokenCookie(req);
        if (tokenId != null) {
            try {
                CookieTokenService tokenService = AbstractTokenService.getInstance(CookieTokenService.class);
                tokenService.deleteToken(tokenId);
            }
            catch (Exception e) {
                LOG.warn((Object)("Cannot delete the token '" + tokenId + "'"), (Throwable)e);
            }
        }
    }

    private String getTokenCookie(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"rememberme".equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    protected boolean requirePortalEnvironment() {
        return true;
    }
}

