/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.exoplatform.container.ExoContainer;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.jboss.web.tomcat.service.sso.ClusteredSingleSignOn;

public class PortalClusteredSSOSupportValve
extends ValveBase {
    private static final String NOTE_CREDENTIALS = "org.exoplatform.web.login.PortalClusteredSSOSupportValve.NOTE_CREDENTIALS";
    private static final Logger log = LoggerFactory.getLogger(PortalClusteredSSOSupportValve.class);
    private ClusteredSingleSignOn ssoValve = null;
    private Context context = null;

    public void setContainer(Container container) {
        if (!(container instanceof Context)) {
            throw new IllegalArgumentException(sm.getString("authenticator.notContext"));
        }
        super.setContainer(container);
        this.context = (Context)container;
        this.findSSOValve();
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.ssoValve != null) {
            Session tomcatSession = request.getSessionInternal();
            if ("/login".equals(request.getServletPath()) && request.getNote("org.apache.catalina.request.SSOID") == null) {
                String password = request.getParameter("password");
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Saving ccredentials into session note for SSO valve.");
                }
                tomcatSession.setNote(NOTE_CREDENTIALS, (Object)password);
            } else if (tomcatSession.getNote(NOTE_CREDENTIALS) != null && tomcatSession.getPrincipal() != null) {
                String password = (String)tomcatSession.getNote(NOTE_CREDENTIALS);
                tomcatSession.removeNote(NOTE_CREDENTIALS);
                String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
                if (password != null && ssoId != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Update SSO valve values with real credentials of user " + request.getRemoteUser()));
                    }
                    this.ssoValve.register(ssoId, tomcatSession.getPrincipal(), tomcatSession.getAuthType(), request.getRemoteUser(), password);
                }
            }
        }
        this.getNext().invoke(request, response);
    }

    private void findSSOValve() {
        if (!ExoContainer.getProfiles().contains("cluster")) {
            return;
        }
        Container parent = this.context.getParent();
        while (this.ssoValve == null && parent != null) {
            if (!(parent instanceof Pipeline)) {
                parent = parent.getParent();
                continue;
            }
            Valve[] valves = ((Pipeline)parent).getValves();
            for (Valve valve : ((Pipeline)parent).getValves()) {
                if (!(valve instanceof ClusteredSingleSignOn)) continue;
                this.ssoValve = (ClusteredSingleSignOn)valve;
                break;
            }
            if (this.ssoValve != null) continue;
            parent = parent.getParent();
        }
        if (this.ssoValve != null) {
            log.info((Object)("Found JBoss ClusteredSingleSignOn Valve at " + this.ssoValve));
        } else {
            log.info((Object)"No JBoss ClusteredSingleSignOn Valve is present");
        }
    }
}

