/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.web.AbstractHttpServlet;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.web.security.AuthenticationRegistry;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.wci.security.Credentials;

public class DoLoginServlet
extends AbstractHttpServlet {
    private static final Logger log = LoggerFactory.getLogger(DoLoginServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String initialURI = req.getParameter("initialURI");
        log.debug((Object)("Performing the do login send redirect with initialURI=" + initialURI + " and remoteUser=" + req.getRemoteUser()));
        if (initialURI == null || initialURI.length() == 0) {
            initialURI = req.getContextPath();
        }
        try {
            URI uri = new URI(initialURI);
            if (uri.isAbsolute() && !uri.getHost().equals(req.getServerName())) {
                log.warn((Object)"Cannot redirect to an URI outside of the current host when using a login redirect. Redirecting to the portal context path instead.");
                initialURI = req.getContextPath();
            }
        }
        catch (URISyntaxException e) {
            log.warn((Object)"Initial URI in login link is malformed. Redirecting to the portal context path instead.");
            initialURI = req.getContextPath();
        }
        Credentials credentials = this.removeCredentialsFromRegistry(req);
        this.setCredentialsToConversationState(credentials);
        resp.sendRedirect(resp.encodeRedirectURL(initialURI));
    }

    protected Credentials removeCredentialsFromRegistry(HttpServletRequest req) {
        AuthenticationRegistry authenticationRegistry = (AuthenticationRegistry)this.getContainer().getComponentInstanceOfType(AuthenticationRegistry.class);
        return authenticationRegistry.removeCredentials(req);
    }

    protected void setCredentialsToConversationState(Credentials credentials) {
        ConversationState currentConversationState = ConversationState.getCurrent();
        if (currentConversationState != null && credentials != null) {
            log.debug((Object)("Adding credentials to conversationState for user " + credentials.getUsername()));
            currentConversationState.setAttribute("credentials", (Object)credentials);
        }
    }
}

