/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.auth.AuthenticationService;
import org.exoplatform.services.organization.auth.Identity;
import org.exoplatform.web.WebAppController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetCurrentIdentityListener
extends Listener<WebAppController, HttpServletRequest> {
    protected static Log log = ExoLogger.getLogger((String)"authentication:SetCurrentIdentityListener");

    public void onEvent(Event<WebAppController, HttpServletRequest> event) throws Exception {
        PortalContainer container = PortalContainer.getInstance();
        AuthenticationService authService = (AuthenticationService)container.getComponentInstanceOfType(AuthenticationService.class);
        String remoteUser = ((HttpServletRequest)event.getData()).getRemoteUser();
        if (remoteUser != null) {
            Identity identity = authService.getIdentityBySessionId(remoteUser);
            if (identity == null) {
                throw new Exception("Cannot find the identity for user " + remoteUser);
            }
            authService.setCurrentIdentity(identity);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set Identity for user " + remoteUser));
        }
    }
}

