/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.portletcontainer.helper.WindowInfosContainer;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.command.CommandHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppController {
    protected static Log log = ExoLogger.getLogger((String)"portal:WebAppController");
    private HashMap<String, Object> attributes_;
    private HashMap<String, Application> applications_ = new HashMap();
    private HashMap<String, WebRequestHandler> handlers_;

    public WebAppController() throws Exception {
        this.attributes_ = new HashMap();
        this.handlers_ = new HashMap();
        this.register(new CommandHandler());
    }

    public Object getAttribute(String name, Object value) {
        return this.attributes_.get(name);
    }

    public <T extends Application> T getApplication(String appId) {
        return (T)((Object)this.applications_.get(appId));
    }

    public List<Application> getApplicationByType(String type) {
        ArrayList<Application> applications = new ArrayList<Application>();
        for (Application app : this.applications_.values()) {
            if (!app.getApplicationType().equals(type)) continue;
            applications.add(app);
        }
        return applications;
    }

    public void removeApplication(String appId) {
        this.applications_.remove(appId);
    }

    public void addApplication(Application app) {
        this.applications_.put(app.getApplicationId(), app);
    }

    public void register(WebRequestHandler handler) throws Exception {
        for (String path : handler.getPath()) {
            this.handlers_.put(path, handler);
        }
    }

    public void unregister(String[] paths) {
        for (String path : paths) {
            this.handlers_.remove(path);
        }
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws Exception {
        WebRequestHandler handler = this.handlers_.get(req.getServletPath());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Servlet Path: " + req.getServletPath()));
            log.debug((Object)("Handler used for this path: " + handler));
        }
        if (handler != null) {
            PortalContainer portalContainer = PortalContainer.getInstance();
            List components = portalContainer.getComponentInstancesOfType(ComponentRequestLifecycle.class);
            ListenerService lservice = (ListenerService)portalContainer.getComponentInstanceOfType(ListenerService.class);
            lservice.broadcast("exo.application.portal.start-http-request", (Object)this, (Object)req);
            for (ComponentRequestLifecycle component : components) {
                component.startRequest((ExoContainer)portalContainer);
            }
            WindowInfosContainer.createInstance((ExoContainer)portalContainer, (String)req.getSession().getId(), (String)req.getRemoteUser());
            handler.execute(this, req, res);
            for (ComponentRequestLifecycle component : components) {
                component.endRequest((ExoContainer)portalContainer);
            }
            lservice.broadcast("exo.application.portal.end-http-request", (Object)this, (Object)req);
        }
    }
}

