/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.upload;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.upload.RequestStreamReader;
import org.exoplatform.upload.UploadResource;

public class UploadService {
    private Map<String, UploadResource> uploadResources = new LinkedHashMap<String, UploadResource>();
    private String uploadLocation_;

    public UploadService(PortalContainerInfo pinfo) throws Exception {
        String tmpDir = System.getProperty("java.io.tmpdir");
        this.uploadLocation_ = tmpDir + "/" + pinfo.getContainerName() + "/eXoUpload";
        File uploadDir = new File(this.uploadLocation_);
        if (!uploadDir.exists()) {
            uploadDir.mkdirs();
        }
    }

    public void createUploadResource(HttpServletRequest request) throws IOException {
        String uploadId = request.getParameter("uploadId");
        UploadResource upResource = new UploadResource(uploadId);
        RequestStreamReader reader = new RequestStreamReader(upResource);
        String headerEncoding = request.getCharacterEncoding();
        Map<String, String> headers = reader.parseHeaders((InputStream)request.getInputStream(), headerEncoding);
        String fileName = reader.getFileName(headers);
        if (fileName == null) {
            fileName = uploadId;
        }
        fileName = fileName.substring(fileName.lastIndexOf(92) + 1);
        upResource.setFileName(fileName);
        upResource.setMimeType(headers.get("content-type"));
        upResource.setStoreLocation(this.uploadLocation_ + "/" + uploadId + "." + fileName);
        upResource.setEstimatedSize(request.getContentLength());
        this.uploadResources.put(upResource.getUploadId(), upResource);
        File fileStore = new File(upResource.getStoreLocation());
        if (!fileStore.exists()) {
            fileStore.createNewFile();
        }
        FileOutputStream output = new FileOutputStream(fileStore);
        reader.readBodyData(request, output);
        if (upResource.getStatus() == 0) {
            upResource.setStatus(1);
            return;
        }
        this.uploadResources.remove(uploadId);
        fileStore.delete();
    }

    public void createUploadResource(String uploadId, String encoding, String contentType, double contentLength, InputStream inputStream) throws Exception {
        UploadResource upResource = new UploadResource(uploadId);
        RequestStreamReader reader = new RequestStreamReader(upResource);
        Map<String, String> headers = reader.parseHeaders(inputStream, encoding);
        String fileName = reader.getFileName(headers);
        if (fileName == null) {
            fileName = uploadId;
        }
        fileName = fileName.substring(fileName.lastIndexOf(92) + 1);
        upResource.setFileName(fileName);
        upResource.setMimeType(headers.get("content-type"));
        upResource.setStoreLocation(this.uploadLocation_ + "/" + uploadId + "." + fileName);
        upResource.setEstimatedSize(contentLength);
        this.uploadResources.put(upResource.getUploadId(), upResource);
        File fileStore = new File(upResource.getStoreLocation());
        if (!fileStore.exists()) {
            fileStore.createNewFile();
        }
        FileOutputStream output = new FileOutputStream(fileStore);
        reader.readBodyData(inputStream, contentType, output);
        if (upResource.getStatus() == 0) {
            upResource.setStatus(1);
            return;
        }
        this.uploadResources.remove(uploadId);
        fileStore.delete();
    }

    public UploadResource getUploadResource(String uploadId) {
        UploadResource upResource = this.uploadResources.get(uploadId);
        return upResource;
    }

    public void removeUpload(String uploadId) {
        if (uploadId == null) {
            return;
        }
        UploadResource upResource = this.uploadResources.get(uploadId);
        if (upResource == null) {
            return;
        }
        File file = new File(upResource.getStoreLocation());
        file.delete();
        this.uploadResources.remove(uploadId);
    }
}

