/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application.javascript;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.ServletContext;
import org.exoplatform.web.application.javascript.JSMin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavascriptConfigService {
    private Collection<String> availableScripts_;
    private Collection<String> availableScriptsPaths_;
    private String mergedJavascript = "";
    private long lastModified = Long.MAX_VALUE;
    private HashMap<String, String> extendedJavascripts;
    private ByteArrayOutputStream jsStream_ = null;

    public JavascriptConfigService() {
        this.availableScripts_ = new ArrayList<String>();
        this.availableScriptsPaths_ = new ArrayList<String>();
        this.extendedJavascripts = new HashMap();
    }

    public Collection<String> getAvailableScripts() {
        return this.availableScripts_;
    }

    public Collection<String> getAvailableScriptsPaths() {
        return this.availableScriptsPaths_;
    }

    public void addExtendedJavascript(String module, String scriptPath, ServletContext scontext, String scriptData) {
        String servletContextName = scontext.getServletContextName();
        String path = "/" + servletContextName + scriptPath;
        this.availableScripts_.add(module);
        this.availableScriptsPaths_.add(path);
        this.extendedJavascripts.put(path, scriptData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJavascript(String module, String scriptPath, ServletContext scontext) {
        String servletContextName = scontext.getServletContextName();
        this.availableScripts_.add(module);
        this.availableScriptsPaths_.add("/" + servletContextName + scriptPath);
        StringBuffer sB = new StringBuffer();
        String line = "";
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(scontext.getResourceAsStream(scriptPath)));
            try {
                while ((line = reader.readLine()) != null) {
                    sB.append(line + "\n");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    reader.close();
                }
                catch (Exception ex) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sB.append("\n");
        this.mergedJavascript = this.mergedJavascript.concat(sB.toString());
    }

    public byte[] getMergedJavascript() {
        if (this.jsStream_ == null) {
            this.jsStream_ = new ByteArrayOutputStream();
            StringBuffer allJavascript = new StringBuffer();
            allJavascript.append(this.mergedJavascript);
            for (String script : this.extendedJavascripts.values()) {
                allJavascript.append(script);
            }
            ByteArrayInputStream input = new ByteArrayInputStream(allJavascript.toString().getBytes());
            JSMin jsMin = new JSMin(input, this.jsStream_);
            try {
                jsMin.jsmin();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.lastModified = new Date().getTime() / 1000L * 1000L;
        }
        return this.jsStream_.toByteArray();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean isModuleLoaded(CharSequence module) {
        return this.getAvailableScripts().contains(module);
    }

    public void removeExtendedJavascript(String module, String scriptPath, ServletContext scontext) {
        String servletContextName = scontext.getServletContextName();
        this.availableScripts_.remove(module);
        String path = "/" + servletContextName + scriptPath;
        this.availableScriptsPaths_.remove(path);
        this.extendedJavascripts.remove(path);
        this.jsStream_ = null;
    }
}

