/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.json;

import java.util.Map;
import org.exoplatform.json.BeanToJSONPlugin;
import org.exoplatform.json.JSONMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapToJSONPlugin
extends BeanToJSONPlugin<Object> {
    @Override
    public void toJSONScript(Object object, StringBuilder builder, int indentLevel) throws Exception {
        if (object instanceof Map) {
            this.toJSONScript((Map)object, builder, indentLevel);
        }
        if (object instanceof JSONMap) {
            JSONMap jsonMap = (JSONMap)object;
            this.toJSONScript(jsonMap.getJSONMap(), builder, indentLevel);
        }
    }

    @Override
    public void toJSONScript(Map<String, Object> map, StringBuilder builder, int indentLevel) throws Exception {
        this.appendIndentation(builder, indentLevel);
        builder.append('{').append('\n');
        for (String key : map.keySet()) {
            this.appendIndentation(builder, indentLevel + 1);
            builder.append('\'').append(key).append('\'').append(':').append(' ');
            Object value = map.get(key);
            Class<?> type = value.getClass();
            System.out.println("\n\n\n == > " + type + "\n\n");
            if (this.isPrimitiveType(type)) {
                builder.append(value).append(',').append('\n');
                continue;
            }
            if (this.isCharacterType(type)) {
                builder.append('\'').append(this.encode(value.toString())).append('\'').append(',').append('\n');
                continue;
            }
            if (this.isDateType(type)) {
                this.toDateValue(builder, value);
                continue;
            }
            BeanToJSONPlugin plugin = this.service_.getConverterPlugin(value);
            plugin.toJSONScript(value, builder, indentLevel + 1);
        }
        builder.deleteCharAt(builder.length() - 2);
        builder.append('\n');
        this.appendIndentation(builder, indentLevel);
        builder.append('}');
    }
}

