/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.json;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import org.exoplatform.json.JSONService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BeanToJSONPlugin<T> {
    protected JSONService service_;
    protected DateFormat dateFormat_;

    public abstract void toJSONScript(T var1, StringBuilder var2, int var3) throws Exception;

    protected void appendIndentation(StringBuilder builder, int indentLevel) {
        for (int i = 0; i < indentLevel * JSONService.NUMBER_SPACE; ++i) {
            builder.append(' ');
        }
    }

    public void setService(JSONService service) {
        this.service_ = service;
    }

    protected boolean isCharacterType(Class type) {
        return type == Character.TYPE || type == String.class || type == Character.class || type == StringBuilder.class || type == StringBuffer.class;
    }

    protected boolean isDateType(Class type) {
        return type == Date.class || type == Calendar.class;
    }

    protected boolean isPrimitiveType(Class type) {
        return type == Integer.TYPE || type == Long.TYPE || type == Byte.TYPE || type == Double.TYPE || type == Float.TYPE || type == Boolean.TYPE || type == Short.TYPE || type == Integer.class || type == Long.class || type == Boolean.class || type == Double.class || type == Float.class || type == Short.class;
    }

    protected String encode(CharSequence seq) {
        StringBuilder builder = new StringBuilder();
        int start = 0;
        for (int i = 0; i < seq.length(); ++i) {
            if (seq.charAt(i) == '\'') {
                builder.append(seq.subSequence(start, i));
                builder.append('\\').append('\\').append('\'');
                start = i + 1;
                continue;
            }
            if (seq.charAt(i) != '\"') continue;
            builder.append(seq.subSequence(start, i));
            builder.append('\\').append('\"');
            start = i + 1;
        }
        if (start > 0 && start < seq.length()) {
            builder.append(seq.subSequence(start, seq.length()));
        }
        if (builder.length() < 1) {
            return ((Object)seq).toString();
        }
        return builder.toString();
    }

    protected void toDateValue(StringBuilder builder, Object value) {
        String dateValue = null;
        Date date = null;
        if (value instanceof Calendar) {
            date = ((Calendar)value).getTime();
        } else if (value instanceof Date) {
            date = (Date)value;
        }
        dateValue = this.dateFormat_ != null ? this.dateFormat_.format(date) : date.toString();
        builder.append('\'').append(this.encode(dateValue)).append('\'').append(',').append('\n');
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat_ = dateFormat;
    }
}

