/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.json;

import java.lang.reflect.Array;
import org.exoplatform.json.BeanToJSONPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayToJSONPlugin
extends BeanToJSONPlugin<Object> {
    @Override
    public void toJSONScript(Object objects, StringBuilder builder, int indentLevel) throws Exception {
        boolean newBuilder;
        if (!objects.getClass().isArray()) {
            throw new Exception("Object isn't intanceOf array");
        }
        boolean bl = newBuilder = builder.length() < 3;
        if (newBuilder) {
            this.appendIndentation(builder, ++indentLevel);
            String name = "";
            name = Array.getLength(objects) > 0 ? Array.get(objects, 0).getClass().getSimpleName() : objects.getClass().getSimpleName();
            builder.append('\'').append(name).append("s': ");
        }
        if (objects instanceof byte[]) {
            this.toJSON((byte[])objects, builder);
        } else if (objects instanceof short[]) {
            this.toJSON((short[])objects, builder);
        } else if (objects instanceof int[]) {
            this.toJSON((int[])objects, builder);
        } else if (objects instanceof long[]) {
            this.toJSON((long[])objects, builder);
        } else if (objects instanceof float[]) {
            this.toJSON((float[])objects, builder);
        } else if (objects instanceof double[]) {
            this.toJSON((double[])objects, builder);
        } else if (objects instanceof boolean[]) {
            this.toJSON((boolean[])objects, builder);
        } else if (objects instanceof char[]) {
            this.toJSON((char[])objects, builder);
        } else {
            this.objectToJSON((Object[])objects, builder, indentLevel);
        }
        if (newBuilder) {
            this.appendIndentation(builder, indentLevel);
        }
    }

    private <T> void primitiveToJSON(Object object, StringBuilder builder) throws Exception {
        Object[] array = (Object[])object;
        builder.append('[');
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                this.appendIndentation(builder, 1);
            }
            builder.append(array[i]);
            if (i == array.length - 1) continue;
            builder.append(',');
        }
        builder.append(']').append(',').append('\n');
    }

    private <T> void charsToJSON(Object object, StringBuilder builder, int indentLevel) throws Exception {
        Object[] array = (Object[])object;
        builder.append('[').append('\n');
        for (int i = 0; i < array.length; ++i) {
            this.appendIndentation(builder, indentLevel + 1);
            builder.append('\'').append(this.encode(String.valueOf(array[i]))).append('\'');
            if (i != array.length - 1) {
                builder.append(',');
            }
            builder.append('\n');
        }
        this.appendIndentation(builder, indentLevel);
        builder.append(']').append(',').append('\n');
    }

    public <T> void objectToJSON(Object object, StringBuilder builder, int indentLevel) throws Exception {
        Class<?> type = object.getClass().getComponentType();
        if (this.isPrimitiveType(type)) {
            this.primitiveToJSON(object, builder);
            return;
        }
        if (this.isCharacterType(type)) {
            this.charsToJSON(object, builder, indentLevel);
            return;
        }
        Object[] array = (Object[])object;
        builder.append('[').append('\n');
        for (int i = 0; i < array.length; ++i) {
            BeanToJSONPlugin plugin = this.service_.getConverterPlugin(array[i]);
            plugin.toJSONScript(array[i], builder, indentLevel + 1);
            if (i != array.length - 1) {
                builder.append(',');
            }
            this.appendIndentation(builder, indentLevel + 1);
            builder.append('\n');
        }
        this.appendIndentation(builder, indentLevel);
        builder.append(']').append(',').append('\n');
    }

    private void toJSON(int[] array, StringBuilder builder) throws Exception {
        builder.append('[');
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                this.appendIndentation(builder, 1);
            }
            builder.append(array[i]);
            if (i == array.length - 1) continue;
            builder.append(',');
        }
        builder.append(']').append(',').append('\n');
    }

    private void toJSON(short[] array, StringBuilder builder) throws Exception {
        builder.append('[');
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                this.appendIndentation(builder, 1);
            }
            builder.append(array[i]);
            if (i == array.length - 1) continue;
            builder.append(',');
        }
        builder.append(']').append(',').append('\n');
    }

    private void toJSON(byte[] array, StringBuilder builder) throws Exception {
        builder.append('[');
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                this.appendIndentation(builder, 1);
            }
            builder.append(array[i]);
            if (i == array.length - 1) continue;
            builder.append(',');
        }
        builder.append(']').append(',').append('\n');
    }

    private void toJSON(long[] array, StringBuilder builder) throws Exception {
        builder.append('[');
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                this.appendIndentation(builder, 1);
            }
            builder.append(array[i]);
            if (i == array.length - 1) continue;
            builder.append(',');
        }
        builder.append(']').append(',').append('\n');
    }

    private void toJSON(float[] array, StringBuilder builder) throws Exception {
        builder.append('[');
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                this.appendIndentation(builder, 1);
            }
            builder.append(array[i]);
            if (i == array.length - 1) continue;
            builder.append(',');
        }
        builder.append(']').append(',').append('\n');
    }

    private void toJSON(double[] array, StringBuilder builder) throws Exception {
        builder.append('[');
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                this.appendIndentation(builder, 1);
            }
            builder.append(array[i]);
            if (i == array.length - 1) continue;
            builder.append(',');
        }
        builder.append(']').append(',').append('\n');
    }

    private void toJSON(boolean[] array, StringBuilder builder) throws Exception {
        builder.append('[');
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                this.appendIndentation(builder, 1);
            }
            builder.append(array[i]);
            if (i == array.length - 1) continue;
            builder.append(',');
        }
        builder.append(']').append(',').append('\n');
    }

    private void toJSON(char[] array, StringBuilder builder) throws Exception {
        builder.append('[');
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                this.appendIndentation(builder, 1);
            }
            builder.append('\'').append(this.encode(String.valueOf(array[i]))).append('\'');
            if (i == array.length - 1) continue;
            builder.append(',');
        }
        builder.append(']').append(',').append('\n');
    }
}

