/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.chars.chardet;

import org.exoplatform.services.chars.chardet.ICharsetDetectionObserver;
import org.exoplatform.services.chars.chardet.ICharsetDetector;
import org.exoplatform.services.chars.chardet.PSMDetector;

public class Detector
extends PSMDetector
implements ICharsetDetector {
    ICharsetDetectionObserver mObserver = null;

    public Detector() {
    }

    public Detector(int langFlag) {
        super(langFlag);
    }

    public void init(ICharsetDetectionObserver aObserver) {
        this.mObserver = aObserver;
    }

    public boolean doIt(byte[] aBuf, int aLen, boolean oDontFeedMe) {
        if (aBuf == null || oDontFeedMe) {
            return false;
        }
        this.handleData(aBuf, aLen);
        return this.mDone;
    }

    public void done() {
        this.dataEnd();
    }

    public void report(String charset) {
        if (this.mObserver != null) {
            this.mObserver.notify(charset);
        }
    }

    public boolean isAscii(byte[] aBuf, int aLen) {
        for (int i = 0; i < aLen; ++i) {
            if ((0x80 & aBuf[i]) == 0) continue;
            return false;
        }
        return true;
    }
}

