/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.html.parser;

import java.util.LinkedList;
import org.exoplatform.services.chars.SpecChar;
import org.exoplatform.services.html.HTMLNode;
import org.exoplatform.services.html.Name;
import org.exoplatform.services.html.NodeConfig;
import org.exoplatform.services.html.Tag;
import org.exoplatform.services.html.parser.HTML;
import org.exoplatform.services.token.TypeToken;

public class NodeImpl
extends HTMLNode {
    private transient boolean isOpen = false;
    private transient int type = TypeToken.CONTENT;

    public NodeImpl(char[] value, Name name) {
        super(value, name);
    }

    public NodeImpl(char[] value, Name name, int type) {
        super(value, name);
        this.type = type;
        this.children = new LinkedList();
        NodeConfig config = HTML.getConfig(name);
        if (config.end() != Tag.FORBIDDEN && type == TypeToken.TAG) {
            this.isOpen = true;
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setIsOpen(boolean open) {
        this.isOpen = open;
    }

    public int getType() {
        return this.type;
    }

    public StringBuilder buildValue(StringBuilder builder) {
        if (builder.length() > 0) {
            builder.append(SpecChar.n);
        }
        if (this.name != Name.CONTENT && this.name != Name.COMMENT) {
            builder.append('<');
        }
        if (this.type == TypeToken.CLOSE) {
            builder.append('/');
        }
        builder.append(this.value);
        if (this.name != Name.CONTENT && this.name != Name.COMMENT) {
            builder.append('>');
        }
        if (this.type == TypeToken.CLOSE || this.getConfig().hidden()) {
            return builder;
        }
        if (this.children == null) {
            return builder;
        }
        for (HTMLNode ele : this.children) {
            ele.buildValue(builder);
        }
        if (this.getConfig().end() != Tag.FORBIDDEN) {
            builder.append(SpecChar.n).append('<').append('/').append((Object)this.getName()).append('>');
        }
        return builder;
    }
}

