/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rss.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.exoplatform.services.common.DataBuffer;
import org.exoplatform.services.common.HttpClientImpl;
import org.exoplatform.services.html.refs.RefsDecoder;
import org.exoplatform.services.rss.parser.DefaultRSSChannel;
import org.exoplatform.services.rss.parser.DefaultRSSItem;
import org.exoplatform.services.rss.parser.IRSSChannel;
import org.exoplatform.services.rss.parser.IRSSItem;
import org.exoplatform.services.rss.parser.RSSDocument;
import org.exoplatform.services.token.attribute.AttributeParser;
import org.exoplatform.services.token.attribute.Attributes;
import org.exoplatform.services.xml.parser.XMLDocument;
import org.exoplatform.services.xml.parser.XMLNode;
import org.exoplatform.services.xml.parser.XMLParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSSParser {
    private RefsDecoder decoder = new RefsDecoder();

    public synchronized RSSDocument<DefaultRSSChannel, DefaultRSSItem> createDocument(XMLNode root) throws Exception {
        DefaultRSSChannel channel = this.createChannel(root);
        if (channel == null) {
            return null;
        }
        return new RSSDocument<DefaultRSSChannel, DefaultRSSItem>(channel, this.createItems(channel.getNode()));
    }

    public synchronized <T extends IRSSChannel, E extends IRSSItem> RSSDocument<T, E> createDocument(XMLNode root, Class<T> channelClazz, Class<E> itemClazz) throws Exception {
        T channel = this.createChannel(root, channelClazz);
        if (channel == null) {
            return null;
        }
        return new RSSDocument<T, E>(channel, this.createItems(channel.getNode(), itemClazz));
    }

    private DefaultRSSChannel createChannel(XMLNode root) throws Exception {
        return this.createChannel(root, DefaultRSSChannel.class);
    }

    private <T extends IRSSChannel> T createChannel(XMLNode root, Class<T> clazz) throws Exception {
        if (root.isNode("channel") || root.isNode("feed")) {
            return this.createSingleChannel(root, clazz);
        }
        List<XMLNode> list = root.getChildren();
        for (XMLNode ele : list) {
            T channel = this.createChannel(ele, clazz);
            if (channel == null) continue;
            return channel;
        }
        return null;
    }

    private <T extends IRSSChannel> T createSingleChannel(XMLNode root, Class<T> clazz) throws Exception {
        IRSSChannel t = null;
        List<XMLNode> children = root.getChildren();
        t = (IRSSChannel)this.createItem(root, clazz);
        for (XMLNode ele : children) {
            if (ele.getTotalChildren() < 1 || !ele.isNode("generator")) continue;
            t.setGenerator(ele.getChild(0).getNodeValue());
        }
        return (T)t;
    }

    private List<DefaultRSSItem> createItems(XMLNode root) throws Exception {
        return this.createItems(root, DefaultRSSItem.class);
    }

    private <T extends IRSSItem> List<T> createItems(XMLNode root, Class<T> clazz) throws Exception {
        if (root == null) {
            return new ArrayList();
        }
        List<XMLNode> list = root.getChildren();
        ArrayList<T> items = new ArrayList<T>();
        for (XMLNode ele : list) {
            if (!ele.isNode("item") && !ele.isNode("entry")) continue;
            items.add(this.createItem(ele, clazz));
        }
        if (items.size() < 1) {
            return this.createItems(root.getParent(), clazz);
        }
        return items;
    }

    private <T extends IRSSItem> T createItem(XMLNode node, Class<T> clazz) throws Exception {
        IRSSItem item = (IRSSItem)clazz.newInstance();
        item.setNode(node);
        List<XMLNode> children = node.getChildren();
        if (children.size() < 1) {
            return null;
        }
        for (XMLNode ele : children) {
            if (ele.isNode("title") && ele.getTotalChildren() > 0) {
                item.setTitle(this.removeCData(ele.getChild(0).getNodeValue().trim()));
                continue;
            }
            if ((ele.isNode("description") || ele.isNode("summary") || ele.isNode("content")) && ele.getTotalChildren() > 0) {
                if (item.getDesc() != null && item.getDesc().trim().length() >= 1) continue;
                item.setDesc(this.decoder.decode(this.removeCData(ele.getChild(0).getNodeValue().trim())));
                continue;
            }
            if (ele.isNode("link")) {
                if (ele.getTotalChildren() > 0) {
                    item.setLink(this.removeCData(ele.getChild(0).getNodeValue()));
                    continue;
                }
                Attributes attributes = AttributeParser.getAttributes(ele);
                item.setLink(this.removeCData(attributes.getAttributeValue("href")));
                continue;
            }
            if ((ele.isNode("pubDate") || ele.isNode("issued")) && ele.getTotalChildren() > 0) {
                item.setTime(this.removeCData(ele.getChild(0).getNodeValue().trim()));
                continue;
            }
            if (ele.isNode("image") && ele.getTotalChildren() > 0) {
                item.setImage(ele.getChild(0).getNodeValue());
                continue;
            }
            if (!ele.isNode("dc:creator") || ele.getTotalChildren() <= 0) continue;
            item.setCreator(ele.getChild(0).getNodeValue());
        }
        return (T)item;
    }

    private String removeCData(String text) {
        int idx = text.indexOf("[CDATA[");
        if (idx != 1) {
            return text;
        }
        if ((idx = (text = text.substring(idx + 7)).lastIndexOf("]]")) != text.length() - 2) {
            return text;
        }
        return text.substring(0, text.length() - 2);
    }

    public synchronized <T extends IRSSChannel, E extends IRSSItem> RSSDocument<T, E> createDocument(String text, Class<T> channelClazz, Class<E> itemClazz) throws Exception {
        XMLDocument document = XMLParser.createDocument(text);
        if (document == null) {
            return null;
        }
        return this.createDocument(document.getRoot(), channelClazz, itemClazz);
    }

    public synchronized RSSDocument<DefaultRSSChannel, DefaultRSSItem> createDocument(String text) throws Exception {
        XMLDocument document = XMLParser.createDocument(text);
        if (document == null) {
            return null;
        }
        return this.createDocument(document.getRoot(), DefaultRSSChannel.class, DefaultRSSItem.class);
    }

    public synchronized RSSDocument<DefaultRSSChannel, DefaultRSSItem> createDocument(byte[] data, String charset) throws Exception {
        return this.createDocument(new String(data, charset), DefaultRSSChannel.class, DefaultRSSItem.class);
    }

    public synchronized <T extends IRSSChannel, E extends IRSSItem> RSSDocument<T, E> createDocument(byte[] data, String charset, Class<T> channelClazz, Class<E> itemClazz) throws Exception {
        return this.createDocument(new String(data, charset), channelClazz, itemClazz);
    }

    public synchronized <T extends IRSSChannel, E extends IRSSItem> RSSDocument<T, E> createDocument(InputStream input, String charset, Class<T> channelClazz, Class<E> itemClazz) throws Exception {
        XMLDocument document = XMLParser.createDocument(input, charset);
        if (document == null) {
            return null;
        }
        return this.createDocument(document.getRoot(), channelClazz, itemClazz);
    }

    public synchronized RSSDocument<DefaultRSSChannel, DefaultRSSItem> createDocument(InputStream input, String charset) throws Exception {
        XMLDocument document = XMLParser.createDocument(input, charset);
        if (document == null) {
            return null;
        }
        return this.createDocument(document.getRoot(), DefaultRSSChannel.class, DefaultRSSItem.class);
    }

    public synchronized <T extends IRSSChannel, E extends IRSSItem> RSSDocument<T, E> createDocument(File file, String charset, Class<T> channelClazz, Class<E> itemClazz) throws Exception {
        return this.createDocument(new FileInputStream(file), charset, channelClazz, itemClazz);
    }

    public synchronized RSSDocument<DefaultRSSChannel, DefaultRSSItem> createDocument(File file, String charset) throws Exception {
        if (!file.exists()) {
            return null;
        }
        return this.createDocument(new FileInputStream(file), charset, DefaultRSSChannel.class, DefaultRSSItem.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <T extends IRSSChannel, E extends IRSSItem> RSSDocument<T, E> createDocument(URL url, String charset, Class<T> channelClazz, Class<E> itemClazz) throws Exception {
        GetMethod get = null;
        try {
            HttpClientImpl httpClientService = new HttpClientImpl(url);
            get = httpClientService.getMethod(url.getFile());
            get.setFollowRedirects(true);
            int statusCode = httpClientService.getHttpClient().executeMethod((HttpMethod)get);
            if (statusCode != 200) {
                throw new MalformedURLException("Server response code " + statusCode);
            }
            InputStream input = get.getResponseBodyAsStream();
            DataBuffer buffer = new DataBuffer();
            byte[] data = buffer.loadInputStream(input).toByteArray();
            RSSDocument<T, E> rSSDocument = this.createDocument(data, charset, channelClazz, itemClazz);
            return rSSDocument;
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
    }

    public synchronized <T extends IRSSChannel, E extends IRSSItem> RSSDocument<T, E> createDocument(URI uri, String charset, Class<T> channelClazz, Class<E> itemClazz) throws Exception {
        try {
            return this.createDocument(uri.toURL(), charset, channelClazz, itemClazz);
        }
        catch (Exception e) {
            try {
                File file = new File(uri);
                return this.createDocument(file, charset, channelClazz, itemClazz);
            }
            catch (Exception exp) {
                return null;
            }
        }
    }

    public synchronized RSSDocument<DefaultRSSChannel, DefaultRSSItem> createDocument(URI uri, String charset) throws Exception {
        return this.createDocument(uri, charset, DefaultRSSChannel.class, DefaultRSSItem.class);
    }
}

