/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.parser;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.chars.SpecChar;
import org.exoplatform.services.token.Node;
import org.exoplatform.services.token.TypeToken;
import org.exoplatform.services.xml.parser.Services;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLNode
implements Node<String> {
    protected XMLNode parent;
    protected char[] value;
    protected String name;
    protected List<XMLNode> children;
    private transient boolean isOpen = false;
    private transient int type = TypeToken.CONTENT;

    public XMLNode(char[] value, String name, int type) {
        this.value = value;
        this.name = name;
        this.type = type;
        this.children = new ArrayList<XMLNode>();
        this.isOpen = type == TypeToken.TAG;
    }

    public void setParent(XMLNode p) {
        this.parent = p;
    }

    public XMLNode getParent() {
        return this.parent;
    }

    public void addChild(XMLNode ele) {
        this.children.add(ele);
        ele.setParent(this);
    }

    public List<XMLNode> getChildren() {
        return this.children;
    }

    public int getTotalChildren() {
        return this.children.size();
    }

    @Override
    public char[] getValue() {
        return this.value;
    }

    @Override
    public void setValue(char[] value) {
        this.value = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNode(String n) {
        if (this.name == null) {
            return false;
        }
        return this.name.equalsIgnoreCase(n);
    }

    boolean isOpen() {
        return this.isOpen;
    }

    void setIsOpen(boolean open) {
        this.isOpen = open;
    }

    int getType() {
        return this.type;
    }

    public String getTextValue() {
        return this.getTextValue(false);
    }

    public String getTextValue(boolean encode) {
        StringBuilder builder = new StringBuilder();
        this.buildValue(builder, 0, encode);
        return builder.toString();
    }

    public XMLNode getChild(int i) {
        return this.children.get(i);
    }

    public String getNodeValue() {
        return new String(this.value);
    }

    public void buildValue(StringBuilder builder, boolean encode) {
        this.buildValue(builder, 0, encode);
    }

    private void buildValue(StringBuilder builder, int tab, boolean encode) {
        if (tab > 0) {
            builder.append(SpecChar.n);
        }
        for (int i = 0; i < tab; ++i) {
            builder.append(SpecChar.s);
        }
        if (this.type != TypeToken.CONTENT && this.type != TypeToken.COMMENT) {
            builder.append('<');
        }
        if (encode && (this.type == TypeToken.CONTENT || this.type == TypeToken.COMMENT)) {
            this.value = Services.ENCODER.getRef().encode(this.value);
        }
        builder.append(this.value);
        if (this.type != TypeToken.CONTENT && this.type != TypeToken.COMMENT) {
            builder.append('>');
        }
        if (this.children == null) {
            return;
        }
        if (this.children.size() == 1 && this.children.get(0).getType() != TypeToken.TAG && this.children.get((int)0).value.length < 20) {
            tab = -3;
        }
        for (XMLNode ele : this.children) {
            ele.buildValue(builder, tab + 2, encode);
        }
        if (this.type == TypeToken.TAG) {
            if (tab > -1) {
                builder.append(SpecChar.n);
            }
            for (int i = 0; i < tab; ++i) {
                builder.append(SpecChar.s);
            }
            builder.append('<').append('/').append(this.getName()).append('>');
        }
    }
}

