/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.parser;

import org.exoplatform.services.chars.CharsUtil;
import org.exoplatform.services.chars.SpecChar;
import org.exoplatform.services.html.refs.RefsDecoder;
import org.exoplatform.services.token.TokenParser;
import org.exoplatform.services.token.TypeToken;
import org.exoplatform.services.xml.parser.XMLNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLToken
extends TokenParser.Factory<XMLNode> {
    private XMLNode xmlType;
    private RefsDecoder refs = new RefsDecoder();

    @Override
    public int create(char[] data, int start, int end, int type) {
        if (start >= end) {
            return end;
        }
        if (start > data.length) {
            return data.length;
        }
        char[] value = CharsUtil.cutAndTrim(data, start, Math.min(end, data.length));
        if (value.length < 1) {
            return end;
        }
        if (type != TypeToken.TAG) {
            value = this.refs.decode(value);
            this.push(new XMLNode(value, null, type));
            return end;
        }
        if (value[0] == SpecChar.END_TAG) {
            if (value.length <= 1) {
                return end;
            }
            value = CharsUtil.cutAndTrim(value, 1, value.length);
            this.push(new XMLNode(value, new String(value), TypeToken.CLOSE));
            return end;
        }
        String nameValue = new String(CharsUtil.cutBySpace(value, 0));
        if (value[value.length - 1] == SpecChar.QUESTION_MASK && value[0] == SpecChar.QUESTION_MASK) {
            this.xmlType = new XMLNode(value, nameValue, TypeToken.SINGLE);
        } else {
            this.push(new XMLNode(value, nameValue, this.isSingleTag(value)));
        }
        return end;
    }

    int isSingleTag(char[] value) {
        if (value[value.length - 1] == SpecChar.END_TAG) {
            return TypeToken.SINGLE;
        }
        if (value[0] == SpecChar.PUNCTUATION_MASK) {
            return TypeToken.SINGLE;
        }
        return TypeToken.TAG;
    }

    public XMLNode getXmlType() {
        return this.xmlType;
    }
}

