/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.html;

import java.util.LinkedList;
import java.util.List;
import org.exoplatform.services.html.Name;
import org.exoplatform.services.html.NodeConfig;
import org.exoplatform.services.html.Tag;
import org.exoplatform.services.html.parser.HTML;
import org.exoplatform.services.token.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HTMLNode
implements Node<Name> {
    protected char[] value;
    protected Name name;
    protected HTMLNode parent = null;
    protected List<HTMLNode> children;

    protected HTMLNode(char[] value, Name name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public char[] getValue() {
        return this.value;
    }

    @Override
    public void setValue(char[] value) {
        this.value = value;
    }

    public NodeConfig getConfig() {
        return HTML.getConfig(this.name);
    }

    public boolean isNode(String nodeName) {
        return this.name.toString().equalsIgnoreCase(nodeName);
    }

    public boolean isNode(Name n) {
        return this.name == n;
    }

    @Override
    public Name getName() {
        return this.name;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public HTMLNode getParent() {
        return this.parent;
    }

    public void setParent(HTMLNode parent) {
        this.parent = parent;
    }

    public void addChild(HTMLNode ele) {
        NodeConfig config = this.getConfig();
        if (config.end() == Tag.FORBIDDEN) {
            return;
        }
        this.children.add(ele);
    }

    public List<HTMLNode> getChildren() {
        return this.children;
    }

    public List<HTMLNode> getChildrenNode() {
        LinkedList<HTMLNode> list = new LinkedList<HTMLNode>();
        if (this.children == null) {
            return list;
        }
        for (HTMLNode ele : this.children) {
            if (this.name == Name.CONTENT || this.name == Name.COMMENT) continue;
            list.add(ele);
        }
        return list;
    }

    public String getTextValue() {
        StringBuilder builder = new StringBuilder();
        this.buildValue(builder);
        return builder.toString();
    }

    public abstract StringBuilder buildValue(StringBuilder var1);
}

