/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.services.text.TextConfig;
import org.exoplatform.services.token.TypeToken;
import org.exoplatform.services.xml.parser.XMLDocument;
import org.exoplatform.services.xml.parser.XMLNode;
import org.exoplatform.services.xml.parser.XMLParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLProperties
extends HashMap<String, String> {
    protected XMLDocument document;
    protected XMLNode node_;

    public XMLProperties(InputStream input, String name, boolean readonly) throws Exception {
        this.toProperties(XMLParser.createDocument(input, TextConfig.CHARSET), name, readonly);
    }

    public XMLProperties(File file, String name, boolean readonly) throws Exception {
        this.toProperties(XMLParser.createDocument(file, TextConfig.CHARSET), name, readonly);
    }

    public void toProperties(XMLDocument xmlDocument, String name, boolean readonly) throws Exception {
        XMLNode node = null;
        XMLNode root = xmlDocument.getRoot();
        if (root.getChildren().size() > 0) {
            node = this.getNode(root, name);
        }
        if (!readonly) {
            this.node_ = node;
            this.document = xmlDocument;
            if (this.node_ == null) {
                this.node_ = new XMLNode(name.toCharArray(), name, TypeToken.TAG);
                this.document.getRoot().addChild(this.node_);
            }
        }
        if (node == null) {
            return;
        }
        List<XMLNode> children = node.getChildren();
        if (children == null) {
            return;
        }
        for (XMLNode child : children) {
            String value = null;
            if (child.getChildren().size() > 0) {
                value = child.getChild(0).getTextValue();
            }
            super.put(child.getNodeValue(), value);
        }
    }

    public byte[] getBytes() throws Exception {
        if (this.document == null) {
            return null;
        }
        Iterator iter = this.keySet().iterator();
        this.node_.getChildren().clear();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            XMLNode ele = new XMLNode(key.toCharArray(), key, TypeToken.TAG);
            XMLNode child = new XMLNode(((String)this.get(key)).toCharArray(), null, TypeToken.CONTENT);
            ele.addChild(child);
            this.node_.addChild(ele);
        }
        return this.document.getTextValue().getBytes(TextConfig.CHARSET);
    }

    public OutputStream toOutputStream() throws Exception {
        if (this.document == null) {
            return null;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        output.write(this.getBytes());
        return output;
    }

    protected XMLNode getNode(XMLNode root, String name) {
        if (root.getName() == null) {
            return null;
        }
        if (root.getName().equalsIgnoreCase(name)) {
            return root;
        }
        List<XMLNode> children = root.getChildren();
        for (XMLNode child : children) {
            XMLNode value = this.getNode(child, name);
            if (value == null) continue;
            return value;
        }
        return null;
    }
}

