/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.html.parser;

import java.io.File;
import java.io.InputStream;
import org.exoplatform.services.chars.CharsDecoder;
import org.exoplatform.services.chars.chardet.Detector;
import org.exoplatform.services.chars.chardet.ICharsetDetectionObserver;
import org.exoplatform.services.common.DataReader;
import org.exoplatform.services.common.ServiceConfig;
import org.exoplatform.services.common.ServicesContainer;
import org.exoplatform.services.html.HTMLDocument;
import org.exoplatform.services.html.HTMLNode;
import org.exoplatform.services.html.parser.CharsToken;
import org.exoplatform.services.html.parser.NodeImpl;
import org.exoplatform.services.html.parser.ParserService;
import org.exoplatform.services.token.TypeToken;

public final class HTMLParser {
    private static String charset_ = null;
    private static final String READER_ID = "HTMLParserReader";

    public static synchronized HTMLNode clone(HTMLNode node) {
        NodeImpl nodeImpl = (NodeImpl)node;
        NodeImpl newNode = null;
        newNode = nodeImpl.getType() == TypeToken.CONTENT || nodeImpl.getType() == TypeToken.COMMENT ? new NodeImpl(nodeImpl.getValue(), nodeImpl.getName()) : new NodeImpl(nodeImpl.getValue(), nodeImpl.getName(), nodeImpl.getType());
        return newNode;
    }

    public static synchronized HTMLDocument createDocument(char[] data) throws Exception {
        HTMLDocument document = new HTMLDocument();
        CharsToken tokens = new CharsToken();
        tokens.setDocument(document);
        ParserService.getTokenParser().createBeans(tokens, data);
        ParserService.parse(tokens, document);
        return document;
    }

    public static synchronized HTMLDocument createDocument(String text) throws Exception {
        return HTMLParser.createDocument(text.toCharArray());
    }

    public static synchronized HTMLDocument createDocument(byte[] data, String charset) throws Exception {
        if (charset == null) {
            charset = HTMLParser.detect(data);
        }
        char[] chars = CharsDecoder.decode(charset, data, 0, data.length);
        return HTMLParser.createDocument(chars);
    }

    public static synchronized HTMLDocument createDocument(InputStream input, String charset) throws Exception {
        DataReader reader = ServicesContainer.get(ServiceConfig.ServiceType.SOFT_REFERENCE, READER_ID, DataReader.class);
        return HTMLParser.createDocument(reader.loadInputStream(input).toByteArray(), charset);
    }

    public static synchronized HTMLDocument createDocument(File file, String charset) throws Exception {
        DataReader reader = ServicesContainer.get(ServiceConfig.ServiceType.SOFT_REFERENCE, READER_ID, DataReader.class);
        return HTMLParser.createDocument(reader.load(file), charset);
    }

    public static String detect(byte[] buf) {
        Detector det = new Detector(0);
        charset_ = null;
        det.init(new ICharsetDetectionObserver(){

            public void notify(String charset) {
                charset_ = charset;
            }
        });
        boolean isAscii = true;
        int len = buf.length;
        isAscii = det.isAscii(buf, len);
        if (!isAscii) {
            det.doIt(buf, len, false);
        }
        det.dataEnd();
        if (isAscii) {
            charset_ = "ASCII";
        }
        return charset_;
    }

    public static String getCharset() {
        return charset_;
    }
}

