/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.html.refs;

import org.exoplatform.services.html.refs.CharRef;
import org.exoplatform.services.html.refs.CharRefs;
import org.exoplatform.services.html.refs.CharsSequence;
import org.exoplatform.services.html.refs.EncodeService;

public class RefsEncoder {
    private boolean hexadecimal = false;

    public RefsEncoder(boolean hexadecimalV) {
        this.hexadecimal = hexadecimalV;
    }

    public char[] encode(char[] chars) {
        CharRefs charRefs = EncodeService.ENCODE_CHARS_REF.getRef();
        if (!charRefs.isSorted()) {
            charRefs.sort(EncodeService.comparator);
        }
        CharsSequence refValue = new CharsSequence(chars.length * 6);
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            CharRef ref = charRefs.searchByValue(c, EncodeService.comparator);
            if (ref != null) {
                refValue.append('&');
                refValue.append(ref.getName());
                refValue.append(';');
                continue;
            }
            if (c >= '\u007f') {
                refValue.append("&#");
                if (this.hexadecimal) {
                    refValue.append('x');
                    refValue.append(Integer.toHexString(c));
                } else {
                    refValue.append(String.valueOf((int)c));
                }
                refValue.append(';');
                continue;
            }
            refValue.append(String.valueOf((int)c));
        }
        return refValue.getValues();
    }
}

