/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.payload;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.gatein.wsrp.WSRPTypeFactory;
import org.oasis.wsrp.v2.NamedString;
import org.oasis.wsrp.v2.NamedStringArray;

public class SerializableNamedStringArray
implements Serializable {
    private SerializableNamedString[] strings;

    SerializableNamedStringArray(NamedStringArray array) {
        this.initFrom(array);
    }

    void initFrom(NamedStringArray array) {
        List namedString = array.getNamedString();
        this.strings = new SerializableNamedString[namedString.size()];
        int i = 0;
        for (NamedString string : namedString) {
            this.strings[i++] = new SerializableNamedString(string.getName(), string.getValue());
        }
    }

    NamedStringArray toNamedStringArray() {
        NamedStringArray array = WSRPTypeFactory.createNamedStringArray();
        ArrayList<NamedString> namedString = new ArrayList<NamedString>(this.strings.length);
        for (SerializableNamedString string : this.strings) {
            namedString.add(WSRPTypeFactory.createNamedString(string.name, string.value));
        }
        array.getNamedString().addAll(namedString);
        return array;
    }

    private static class SerializableNamedString
    implements Serializable {
        String name;
        String value;

        private SerializableNamedString(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

