/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.jcr.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.StateKey;
import org.exoplatform.services.security.web.HttpSessionStateKey;

public class ThreadLocalSessionProviderInitializedFilter
extends AbstractFilter {
    private ConversationRegistry stateRegistry;
    private SessionProviderService providerService;
    private static final Log log = ExoLogger.getLogger("exo.jcr.framework.command.ThreadLocalSessionProviderInitializedFilter");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ExoContainer container = this.getContainer();
        this.providerService = (SessionProviderService)container.getComponentInstanceOfType(SessionProviderService.class);
        this.stateRegistry = (ConversationRegistry)container.getComponentInstanceOfType(ConversationRegistry.class);
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        ConversationState state = ConversationState.getCurrent();
        SessionProvider provider = null;
        HttpSession httpSession = httpRequest.getSession(false);
        if (state == null) {
            if (log.isDebugEnabled()) {
                log.debug("Current conversation state is not set");
            }
            if (httpSession != null) {
                HttpSessionStateKey stateKey = new HttpSessionStateKey(httpSession);
                state = this.stateRegistry.getState((StateKey)stateKey);
                if (state != null) {
                    provider = new SessionProvider(state);
                } else if (log.isDebugEnabled()) {
                    log.debug("WARN: Conversation State is null, id  " + httpSession.getId());
                }
            }
        } else {
            provider = new SessionProvider(state);
        }
        if (provider == null) {
            if (log.isDebugEnabled()) {
                log.debug("Create SessionProvider for anonymous.");
            }
            provider = SessionProvider.createAnonimProvider();
        }
        try {
            if (ConversationState.getCurrent() != null) {
                ConversationState.getCurrent().setAttribute("JCRsessionProvider", (Object)provider);
            }
            this.providerService.setSessionProvider(null, provider);
            chain.doFilter(request, response);
        }
        finally {
            if (ConversationState.getCurrent() != null) {
                try {
                    ConversationState.getCurrent().removeAttribute("JCRsessionProvider");
                }
                catch (Exception e) {
                    log.warn("An error occured while removing the session provider from the conversation state", e);
                }
            }
            if (this.providerService.getSessionProvider(null) != null) {
                try {
                    this.providerService.removeSessionProvider(null);
                }
                catch (Exception e) {
                    log.warn("An error occured while cleaning the ThreadLocal", e);
                }
            }
        }
    }

    public void destroy() {
    }
}

