/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.registration.policies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.gatein.common.util.ParameterValidation;
import org.gatein.registration.Consumer;
import org.gatein.registration.DuplicateRegistrationException;
import org.gatein.registration.InvalidConsumerDataException;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationException;
import org.gatein.registration.RegistrationManager;
import org.gatein.registration.RegistrationPolicy;
import org.gatein.registration.RegistrationPortletContextChangeListener;
import org.gatein.registration.RegistrationStatus;
import org.gatein.registration.policies.RegistrationPolicyWrapper;
import org.gatein.registration.policies.RegistrationPropertyValidator;
import org.gatein.wsrp.registration.PropertyDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRegistrationPolicy
implements RegistrationPolicy {
    private RegistrationPropertyValidator validator;
    private static final Logger log = LoggerFactory.getLogger(DefaultRegistrationPolicy.class);
    List<String> defaultPortletHandleList = new ArrayList<String>();
    List<RegistrationPortletContextChangeListener> listeners;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultRegistrationPolicy that = (DefaultRegistrationPolicy)o;
        return this.validator.equals(that.validator);
    }

    public int hashCode() {
        return this.validator.hashCode();
    }

    @Override
    public void validateRegistrationDataFor(Map<QName, Object> registrationProperties, String consumerIdentity, Map<QName, ? extends PropertyDescription> expectations, RegistrationManager manager) throws IllegalArgumentException, RegistrationException {
        Consumer consumer;
        ParameterValidation.throwIllegalArgExceptionIfNull(registrationProperties, (String)"Registration properties");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerIdentity, (String)"Consumer identity", null);
        StringBuilder message = new StringBuilder();
        if (expectations != null) {
            Set<QName> expectedNames = expectations.keySet();
            boolean consistentWithExpectations = true;
            HashSet<QName> unexpected = new HashSet<QName>(registrationProperties.keySet());
            unexpected.removeAll(expectedNames);
            if (!unexpected.isEmpty()) {
                consistentWithExpectations = false;
                message.append("Consumer '").append(consumerIdentity).append("' provided values for unexpected registration properties:\n");
                for (QName name : unexpected) {
                    message.append("\t- ").append(name).append("\n");
                }
            }
            for (Map.Entry<QName, ? extends PropertyDescription> entry : expectations.entrySet()) {
                QName name = entry.getKey();
                Object value = registrationProperties.get(name);
                try {
                    this.validator.validateValueFor(name, value);
                }
                catch (IllegalArgumentException e) {
                    message.append("Missing value for expected '").append(name.getLocalPart()).append("' property.\n");
                    consistentWithExpectations = false;
                }
            }
            if (!consistentWithExpectations) {
                String messageString = message.toString();
                log.debug(messageString);
                throw new InvalidConsumerDataException(messageString);
            }
        }
        if ((consumer = manager.getConsumerByIdentity(consumerIdentity)) != null && !RegistrationStatus.PENDING.equals(consumer.getStatus())) {
            for (Registration registration : consumer.getRegistrations()) {
                if (!registration.hasEqualProperties(registrationProperties)) continue;
                throw new DuplicateRegistrationException("Consumer named '" + consumer.getName() + "' has already been registered with the same set of registration properties. Registration rejected!");
            }
        }
    }

    @Override
    public String createRegistrationHandleFor(String registrationId) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)registrationId, (String)"Registration id", null);
        return registrationId;
    }

    @Override
    public String getAutomaticGroupNameFor(String consumerName) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerName, (String)"Consumer name", null);
        return null;
    }

    @Override
    public String getConsumerIdFrom(String consumerName, Map<QName, Object> registrationProperties) throws IllegalArgumentException, InvalidConsumerDataException {
        return RegistrationPolicyWrapper.sanitizeConsumerName(consumerName);
    }

    @Override
    public void validateConsumerName(String consumerName, RegistrationManager manager) throws IllegalArgumentException, RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerName, (String)"Consumer name", null);
        Consumer consumer = manager.getConsumerByIdentity(this.getConsumerIdFrom(consumerName, Collections.<QName, Object>emptyMap()));
        if (consumer != null) {
            throw new DuplicateRegistrationException("A Consumer named '" + consumerName + "' has already been registered.");
        }
    }

    @Override
    public void validateConsumerGroupName(String groupName, RegistrationManager manager) throws IllegalArgumentException, RegistrationException {
    }

    public void setValidator(RegistrationPropertyValidator validator) {
        this.validator = validator;
    }

    public RegistrationPropertyValidator getValidator() {
        return this.validator;
    }

    public void addPortletHandle(Registration registration, String portletHandle) {
        if (registration != null && !registration.getPortletHandles().contains(portletHandle)) {
            registration.getPortletHandles().add(portletHandle);
            this.updatePortletContextListeners(registration);
        }
    }

    public boolean checkPortletHandle(Registration registration, String portletHandle) {
        if (this.defaultPortletHandleList.contains(portletHandle)) {
            return true;
        }
        return registration != null && registration.getPortletHandles().contains(portletHandle);
    }

    public void removePortletHandle(Registration registration, String portletHandle) {
        if (registration != null) {
            registration.getPortletHandles().remove(portletHandle);
            this.updatePortletContextListeners(registration);
        }
    }

    public void updatePortletHandles(List<String> portletHandles) {
        this.defaultPortletHandleList = portletHandles;
    }

    public void addPortletContextChangeListener(RegistrationPortletContextChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<RegistrationPortletContextChangeListener>();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    protected void updatePortletContextListeners(Registration registration) {
        if (this.listeners != null) {
            for (RegistrationPortletContextChangeListener listener : this.listeners) {
                listener.portletContextsHaveChanged(registration);
            }
        }
    }
}

