/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.handlers;

import java.util.Collections;
import java.util.List;
import javax.portlet.PortletModeException;
import javax.portlet.WindowStateException;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.invocation.response.ContentResponse;
import org.gatein.pc.api.invocation.response.ErrorResponse;
import org.gatein.pc.api.invocation.response.FragmentResponse;
import org.gatein.pc.api.invocation.response.HTTPRedirectionResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.UpdateNavigationalStateResponse;
import org.gatein.pc.portlet.state.producer.PortletStateChangeRequiredException;
import org.gatein.registration.Registration;
import org.gatein.registration.RegistrationLocal;
import org.gatein.wsrp.producer.MarkupInterface;
import org.gatein.wsrp.producer.Utils;
import org.gatein.wsrp.producer.WSRPProducerImpl;
import org.gatein.wsrp.producer.handlers.ServiceHandler;
import org.gatein.wsrp.producer.handlers.processors.ProcessorFactory;
import org.gatein.wsrp.producer.handlers.processors.RequestProcessor;
import org.gatein.wsrp.servlet.ServletAccess;
import org.gatein.wsrp.spec.v2.WSRP2ExceptionFactory;
import org.oasis.wsrp.v2.AccessDenied;
import org.oasis.wsrp.v2.BlockingInteractionResponse;
import org.oasis.wsrp.v2.Extension;
import org.oasis.wsrp.v2.GetMarkup;
import org.oasis.wsrp.v2.GetResource;
import org.oasis.wsrp.v2.HandleEvents;
import org.oasis.wsrp.v2.HandleEventsResponse;
import org.oasis.wsrp.v2.InconsistentParameters;
import org.oasis.wsrp.v2.InitCookie;
import org.oasis.wsrp.v2.InteractionParams;
import org.oasis.wsrp.v2.InvalidCookie;
import org.oasis.wsrp.v2.InvalidHandle;
import org.oasis.wsrp.v2.InvalidRegistration;
import org.oasis.wsrp.v2.InvalidSession;
import org.oasis.wsrp.v2.InvalidUserCategory;
import org.oasis.wsrp.v2.MarkupResponse;
import org.oasis.wsrp.v2.MissingParameters;
import org.oasis.wsrp.v2.ModifyRegistrationRequired;
import org.oasis.wsrp.v2.OperationFailed;
import org.oasis.wsrp.v2.OperationNotSupported;
import org.oasis.wsrp.v2.PerformBlockingInteraction;
import org.oasis.wsrp.v2.PortletStateChangeRequired;
import org.oasis.wsrp.v2.ReleaseSessions;
import org.oasis.wsrp.v2.ResourceResponse;
import org.oasis.wsrp.v2.ResourceSuspended;
import org.oasis.wsrp.v2.UnsupportedLocale;
import org.oasis.wsrp.v2.UnsupportedMimeType;
import org.oasis.wsrp.v2.UnsupportedMode;
import org.oasis.wsrp.v2.UnsupportedWindowState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkupHandler
extends ServiceHandler
implements MarkupInterface {
    public static final String PBI = "PerformBlockingInteraction";
    public static final String GET_MARKUP = "GetMarkup";
    public static final String GET_RESOURCE = "GetResource";
    public static final String HANDLE_EVENTS = "HandleEvents";

    public MarkupHandler(WSRPProducerImpl producer) {
        super(producer);
    }

    @Override
    public MarkupResponse getMarkup(GetMarkup getMarkup) throws AccessDenied, InconsistentParameters, InvalidCookie, InvalidHandle, InvalidRegistration, InvalidSession, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, ResourceSuspended, UnsupportedLocale, UnsupportedMimeType, UnsupportedMode, UnsupportedWindowState {
        PortletInvocationResponse response;
        WSRP2ExceptionFactory.throwOperationFailedIfValueIsMissing((Object)getMarkup, (String)GET_MARKUP);
        RequestProcessor requestProcessor = ProcessorFactory.getProcessorFor(this.producer, getMarkup);
        String handle = requestProcessor.getPortletContext().getPortletHandle();
        try {
            log.debug("RenderInvocation on portlet '" + handle + "'");
            Registration registration = this.producer.getRegistrationOrFailIfInvalid(getMarkup.getRegistrationContext());
            RegistrationLocal.setRegistration(registration);
            response = this.producer.getPortletInvoker().invoke(requestProcessor.getInvocation());
            log.debug("RenderInvocation done");
        }
        catch (PortletInvokerException e) {
            throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)("Could not render portlet '" + handle + "'"), (Throwable)e);
        }
        this.checkForError(response);
        return (MarkupResponse)requestProcessor.processResponse(response);
    }

    @Override
    public ResourceResponse getResource(GetResource getResource) throws AccessDenied, InconsistentParameters, InvalidCookie, InvalidHandle, InvalidRegistration, InvalidSession, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended, UnsupportedLocale, UnsupportedMimeType, UnsupportedMode, UnsupportedWindowState {
        PortletInvocationResponse response;
        WSRP2ExceptionFactory.throwOperationFailedIfValueIsMissing((Object)getResource, (String)GET_RESOURCE);
        RequestProcessor requestProcessor = ProcessorFactory.getProcessorFor(this.producer, getResource);
        String handle = requestProcessor.getPortletContext().getPortletHandle();
        try {
            log.debug("ResourceInvocation on portlet '" + handle + "'");
            Registration registration = this.producer.getRegistrationOrFailIfInvalid(getResource.getRegistrationContext());
            RegistrationLocal.setRegistration(registration);
            response = this.producer.getPortletInvoker().invoke(requestProcessor.getInvocation());
            log.debug("ResourceInvocation done");
        }
        catch (PortletInvokerException e) {
            throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)("Could not access portlet resource '" + handle + "'"), (Throwable)e);
        }
        this.checkForError(response);
        return (ResourceResponse)requestProcessor.processResponse(response);
    }

    @Override
    public BlockingInteractionResponse performBlockingInteraction(PerformBlockingInteraction performBlockingInteraction) throws AccessDenied, InconsistentParameters, InvalidCookie, InvalidHandle, InvalidRegistration, InvalidSession, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, PortletStateChangeRequired, ResourceSuspended, UnsupportedLocale, UnsupportedMimeType, UnsupportedMode, UnsupportedWindowState {
        PortletInvocationResponse response;
        WSRP2ExceptionFactory.throwOperationFailedIfValueIsMissing((Object)performBlockingInteraction, (String)PBI);
        InteractionParams interactionParams = performBlockingInteraction.getInteractionParams();
        WSRP2ExceptionFactory.throwMissingParametersIfValueIsMissing((Object)interactionParams, (String)"InteractionParams", (String)PBI);
        RequestProcessor requestProcessor = ProcessorFactory.getProcessorFor(this.producer, performBlockingInteraction);
        String handle = requestProcessor.getPortletContext().getPortletHandle();
        try {
            log.debug("ActionInvocation on portlet '" + handle + "'");
            Registration registration = this.producer.getRegistrationOrFailIfInvalid(performBlockingInteraction.getRegistrationContext());
            RegistrationLocal.setRegistration(registration);
            response = this.producer.getPortletInvoker().invoke(requestProcessor.getInvocation());
            log.debug("ActionInvocation done");
        }
        catch (PortletStateChangeRequiredException e) {
            throw (PortletStateChangeRequired)WSRP2ExceptionFactory.throwWSException(PortletStateChangeRequired.class, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (PortletInvokerException e) {
            throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)("Could not perform action on portlet '" + handle + "'"), (Throwable)e);
        }
        this.checkForError(response);
        return (BlockingInteractionResponse)requestProcessor.processResponse(response);
    }

    @Override
    public List<Extension> releaseSessions(ReleaseSessions releaseSessions) throws AccessDenied, InvalidRegistration, MissingParameters, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        Utils.throwOperationFaultOnSessionOperation();
        return null;
    }

    @Override
    public List<Extension> initCookie(InitCookie initCookie) throws AccessDenied, InvalidRegistration, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, ResourceSuspended {
        WSRP2ExceptionFactory.throwOperationFailedIfValueIsMissing((Object)initCookie, (String)"InitCookie");
        this.producer.getRegistrationOrFailIfInvalid(initCookie.getRegistrationContext());
        String sessionId = ServletAccess.getRequest().getSession().getId();
        log.debug("Got init cookie operation, created a session with id " + sessionId);
        return Collections.emptyList();
    }

    @Override
    public HandleEventsResponse handleEvents(HandleEvents handleEvents) throws AccessDenied, InconsistentParameters, InvalidCookie, InvalidHandle, InvalidRegistration, InvalidSession, InvalidUserCategory, MissingParameters, ModifyRegistrationRequired, OperationFailed, OperationNotSupported, PortletStateChangeRequired, ResourceSuspended, UnsupportedLocale, UnsupportedMimeType, UnsupportedMode, UnsupportedWindowState {
        PortletInvocationResponse response;
        RequestProcessor requestProcessor = ProcessorFactory.getProcessorFor(this.producer, handleEvents);
        String handle = requestProcessor.getPortletContext().getPortletHandle();
        try {
            log.debug("EventInvocation on portlet '" + handle + "'");
            Registration registration = this.producer.getRegistrationOrFailIfInvalid(handleEvents.getRegistrationContext());
            RegistrationLocal.setRegistration(registration);
            response = this.producer.getPortletInvoker().invoke(requestProcessor.getInvocation());
            log.debug("EventInvocation done");
        }
        catch (PortletStateChangeRequiredException e) {
            throw (PortletStateChangeRequired)WSRP2ExceptionFactory.throwWSException(PortletStateChangeRequired.class, (String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (PortletInvokerException e) {
            throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)("Could not handle event on portlet '" + handle + "'"), (Throwable)e);
        }
        this.checkForError(response);
        return (HandleEventsResponse)requestProcessor.processResponse(response);
    }

    private void checkForError(PortletInvocationResponse response) throws UnsupportedMode, OperationFailed, UnsupportedWindowState {
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResult = (ErrorResponse)response;
            Throwable cause = errorResult.getCause();
            if (cause instanceof PortletModeException) {
                throw (UnsupportedMode)WSRP2ExceptionFactory.throwWSException(UnsupportedMode.class, (String)("Unsupported mode: " + ((PortletModeException)cause).getMode()), null);
            }
            if (cause instanceof WindowStateException) {
                throw (UnsupportedWindowState)WSRP2ExceptionFactory.throwWSException(UnsupportedWindowState.class, (String)("Unsupported window state: " + ((WindowStateException)cause).getState()), null);
            }
            throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)errorResult.getMessage(), (Throwable)cause);
        }
        if (!(response instanceof HTTPRedirectionResponse || response instanceof FragmentResponse || response instanceof UpdateNavigationalStateResponse || response instanceof ContentResponse)) {
            throw (OperationFailed)WSRP2ExceptionFactory.throwWSException(OperationFailed.class, (String)("Unsupported result type: " + response.getClass().getName()), null);
        }
    }
}

