/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.controller.impl;

import java.util.Map;
import org.gatein.common.io.IOTools;
import org.gatein.common.io.Serialization;
import org.gatein.common.io.SerializationFilter;
import org.gatein.common.util.Base64;
import org.gatein.common.util.MapAdapters;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.cache.CacheLevel;
import org.gatein.pc.controller.request.ControllerRequest;
import org.gatein.pc.controller.request.PortletActionRequest;
import org.gatein.pc.controller.request.PortletRenderRequest;
import org.gatein.pc.controller.request.PortletResourceRequest;
import org.gatein.pc.controller.state.PortletPageNavigationalState;
import org.gatein.pc.controller.state.PortletWindowNavigationalState;
import org.gatein.wci.Body;
import org.gatein.wci.WebRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerRequestFactory {
    private final Serialization<PortletPageNavigationalState> serialization;

    public ControllerRequestFactory(Serialization<PortletPageNavigationalState> serialization) {
        this.serialization = serialization;
    }

    public ControllerRequest decode(WebRequest req) {
        return this.decode((Map<String, String[]>)req.getQueryParameterMap(), req.getBody());
    }

    public ControllerRequest decode(Map<String, String[]> queryParameters, Body body) {
        Map bodyParameters = null;
        if (body instanceof Body.Form) {
            bodyParameters = ((Body.Form)body).getParameters();
        }
        return this.decode(queryParameters, bodyParameters);
    }

    public ControllerRequest decode(Map<String, String[]> queryParameterMap, Map<String, String[]> formParameterMap) {
        Map queryParameters = MapAdapters.adapt(queryParameterMap);
        PortletPageNavigationalState pageNavigationalState = null;
        String context = (String)queryParameters.get("pagenavigationalstate");
        if (context != null) {
            byte[] bytes = Base64.decode((String)context, (Base64.EncodingOption)Base64.EncodingOption.USEURLSAFEENCODING);
            pageNavigationalState = (PortletPageNavigationalState)IOTools.unserialize(this.serialization, (SerializationFilter)SerializationFilter.COMPRESSOR, (byte[])bytes);
        }
        String windowId = (String)queryParameters.get("windowid");
        Mode mode = null;
        if (queryParameters.get("mode") != null) {
            mode = Mode.create((String)((String)queryParameters.get("mode")));
        }
        WindowState windowState = null;
        if (queryParameters.get("windowstate") != null) {
            windowState = WindowState.create((String)((String)queryParameters.get("windowstate")));
        }
        String navigationalStateString = (String)queryParameters.get("navigationalstate");
        StateString navigationalState = null;
        if (navigationalStateString != null) {
            navigationalState = StateString.create((String)navigationalStateString);
        }
        PortletWindowNavigationalState windowNavigationalState = new PortletWindowNavigationalState(navigationalState, mode, windowState);
        String phase = (String)queryParameters.get("phase");
        if ("resource".equals(phase)) {
            PortletResourceRequest.FullScope scope;
            StateString resourceState = StateString.create((String)((String)queryParameters.get("resourcestate")));
            String resourceId = (String)queryParameters.get("resourceid");
            CacheLevel resourceCacheLevel = CacheLevel.create((String)((String)queryParameters.get("resourcecacheability")));
            if (CacheLevel.FULL.equals((Object)resourceCacheLevel)) {
                scope = new PortletResourceRequest.FullScope();
            } else if (CacheLevel.PORTLET.equals((Object)resourceCacheLevel)) {
                scope = new PortletResourceRequest.PortletScope(windowNavigationalState);
            } else if (CacheLevel.PAGE.equals((Object)resourceCacheLevel)) {
                scope = new PortletResourceRequest.PageScope(windowNavigationalState, pageNavigationalState);
            } else {
                throw new AssertionError();
            }
            return new PortletResourceRequest(windowId, resourceId, resourceState, formParameterMap, scope);
        }
        if ("action".equals(phase)) {
            StateString interactionState = StateString.create((String)((String)queryParameters.get("interactionstate")));
            return new PortletActionRequest(windowId, interactionState, formParameterMap, windowNavigationalState, pageNavigationalState);
        }
        byte[] bytes = Base64.decode((String)((String)queryParameters.get("publicnavigationalstatechanges")), (Base64.EncodingOption)Base64.EncodingOption.USEURLSAFEENCODING);
        Map publicNavigationalStateChanges = (Map)IOTools.unserialize((Serialization)Serialization.PARAMETER_MAP, (SerializationFilter)SerializationFilter.COMPRESSOR, (byte[])bytes);
        return new PortletRenderRequest(windowId, windowNavigationalState, publicNavigationalStateChanges, pageNavigationalState);
    }
}

