/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.SQLFunction;

public class SQLFunctionRegistry {
    private final Dialect dialect;
    private final Map userFunctions;

    public SQLFunctionRegistry(Dialect dialect, Map userFunctions) {
        this.dialect = dialect;
        this.userFunctions = new HashMap();
        this.userFunctions.putAll(userFunctions);
    }

    public SQLFunction findSQLFunction(String functionName) {
        String name = functionName.toLowerCase();
        SQLFunction userFunction = (SQLFunction)this.userFunctions.get(name);
        return userFunction != null ? userFunction : (SQLFunction)this.dialect.getFunctions().get(name);
    }

    public boolean hasFunction(String functionName) {
        String name = functionName.toLowerCase();
        boolean hasUserFunction = this.userFunctions.containsKey(name);
        return hasUserFunction || this.dialect.getFunctions().containsKey(name);
    }
}

