/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.oauth;

import java.io.Serializable;
import java.util.Date;

public class OAuthEntry
implements Serializable {
    public static final long ONE_YEAR = 31536000000L;
    public static final long FIVE_MINUTES = 300000L;
    static final long serialVersionUID = 2L;
    public String appId;
    public String callbackUrl;
    public boolean callbackUrlSigned;
    public String userId;
    public String token;
    public String tokenSecret;
    public boolean authorized;
    public String consumerKey;
    public Type type;
    public Date issueTime;
    public String domain;
    public String container;
    public String oauthVersion;
    public String callbackToken;
    public int callbackTokenAttempts;

    public OAuthEntry() {
    }

    public OAuthEntry(OAuthEntry old) {
        this.appId = old.appId;
        this.callbackUrl = old.callbackUrl;
        this.callbackUrlSigned = old.callbackUrlSigned;
        this.userId = old.userId;
        this.token = old.token;
        this.tokenSecret = old.tokenSecret;
        this.authorized = old.authorized;
        this.consumerKey = old.consumerKey;
        this.type = old.type;
        this.issueTime = old.issueTime;
        this.domain = old.domain;
        this.container = old.container;
        this.oauthVersion = old.oauthVersion;
        this.callbackToken = old.callbackToken;
        this.callbackTokenAttempts = old.callbackTokenAttempts;
    }

    public boolean isExpired() {
        Date currentDate = new Date();
        return currentDate.compareTo(this.expiresAt()) > 0;
    }

    public Date expiresAt() {
        long expirationTime = this.issueTime.getTime();
        switch (this.type) {
            case REQUEST: {
                expirationTime += 300000L;
                break;
            }
            case ACCESS: {
                expirationTime += 31536000000L;
            }
        }
        return new Date(expirationTime);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        REQUEST,
        ACCESS,
        DISABLED;

    }
}

