/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.mc.impl;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.resolver.MutableSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SingletonSchemaResolverFactory;
import org.picocontainer.ComponentAdapter;

public class MCIntConfig {
    private static final Log log = ExoLogger.getLogger(MCIntConfig.class);
    private Map<String, DeploymentData> confByKey = new HashMap<String, DeploymentData>();
    private Map<String, DeploymentData> confByBean = new HashMap<String, DeploymentData>();

    MCIntConfig() {
        Enumeration<URL> urls = null;
        try {
            urls = Thread.currentThread().getContextClassLoader().getResources("conf/mc-int-config.xml");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get resources: conf/mc-int-config.xml", e);
        }
        UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
        MutableSchemaResolver resolver = SingletonSchemaResolverFactory.getInstance().getSchemaBindingResolver();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            KernelDeployment deployment = this.parseConfigURL(factory, resolver, url);
            List beans = deployment.getBeans();
            for (BeanMetaData mdata : beans) {
                String name = mdata.getName();
                DeploymentData data = this.confByKey.get(name);
                if (data == null) {
                    String bean = mdata.getBean();
                    data = this.confByBean.get(bean);
                }
                if (data != null) {
                    log.warn((Object)("Overriding existing mc-int-beans configuration for bean: " + data.data + " from " + data.deployment.getName() + " with one from " + deployment.getName()));
                }
                this.addConf(new DeploymentData(deployment, mdata));
            }
        }
    }

    public AbstractBeanMetaData getByKey(String key) {
        DeploymentData dd = this.confByKey.get(key);
        if (dd == null) {
            return null;
        }
        return (AbstractBeanMetaData)dd.data;
    }

    public AbstractBeanMetaData getByBean(String bean) {
        DeploymentData dd = this.confByBean.get(bean);
        if (dd == null) {
            return null;
        }
        return (AbstractBeanMetaData)dd.data;
    }

    public AbstractBeanMetaData getByAdapter(ComponentAdapter adapter) {
        Object key = adapter.getComponentKey();
        String strKey = key instanceof Class ? ((Class)key).getName() : String.valueOf(key);
        AbstractBeanMetaData ret = this.getByKey(strKey);
        if (ret != null) {
            return ret;
        }
        ret = this.getByBean(strKey);
        return ret;
    }

    private void addConf(DeploymentData deploymentData) {
        String bean;
        String name = deploymentData.data.getName();
        if (name != null) {
            this.confByKey.put(name, deploymentData);
        }
        if ((bean = deploymentData.data.getBean()) != null) {
            this.confByBean.put(bean, deploymentData);
        }
        if (name == null && bean == null) {
            throw new RuntimeException("Configuration error: bean found with no name and no class in " + deploymentData.deployment.getName());
        }
    }

    private KernelDeployment parseConfigURL(UnmarshallerFactory factory, MutableSchemaResolver resolver, URL url) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Parsing " + url));
        }
        long start = System.currentTimeMillis();
        Unmarshaller unmarshaller = factory.newUnmarshaller();
        KernelDeployment deployment = null;
        try {
            deployment = (KernelDeployment)unmarshaller.unmarshal(url.toString(), (SchemaBindingResolver)resolver);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse xml " + url, e);
        }
        if (deployment == null) {
            throw new RuntimeException("The xml " + url + " is not well formed!");
        }
        deployment.setName(url.toString());
        if (trace) {
            long now = System.currentTimeMillis();
            log.trace((Object)("Parsing " + url + " took " + (now - start) + " milliseconds"));
        }
        return deployment;
    }

    static class DeploymentData {
        KernelDeployment deployment;
        BeanMetaData data;

        public DeploymentData(KernelDeployment deployment, BeanMetaData data) {
            this.deployment = deployment;
            this.data = data;
        }
    }
}

