/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.handler;

import java.net.URL;
import java.util.Date;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.cookie.MalformedCookieException;
import org.apache.commons.httpclient.cookie.RFC2109Spec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieUtil {
    private static final RFC2109Spec cookieParser = new RFC2109Spec();
    private static final Logger log = LoggerFactory.getLogger(CookieUtil.class);
    public static final String SET_COOKIE = "Set-Cookie";
    public static final String COOKIE = "Cookie";

    public static Cookie[] extractCookiesFrom(URL remoteAddress, String[] cookieValues) {
        return CookieUtil.extractCookies(remoteAddress, CookieUtil.coalesceCookies(cookieValues));
    }

    private static String coalesceCookies(String[] cookieValues) {
        assert (cookieValues != null);
        StringBuffer logBuffer = null;
        if (log.isDebugEnabled()) {
            logBuffer = new StringBuffer(128);
            logBuffer.append("Cookie headers:\n");
        }
        int cookieNumber = cookieValues.length;
        StringBuffer cookieBuffer = new StringBuffer(cookieNumber * 128);
        for (int i = 0; i < cookieNumber; ++i) {
            String cookieValue = cookieValues[i];
            cookieBuffer.append(cookieValue);
            if (i < cookieNumber - 1) {
                cookieBuffer.append(',');
            }
            if (!log.isDebugEnabled()) continue;
            logBuffer.append("\t").append(i).append(":\t").append(cookieValue).append("\n");
        }
        if (log.isDebugEnabled()) {
            log.debug(logBuffer.toString());
        }
        return cookieBuffer.toString();
    }

    private static Cookie[] extractCookies(URL hostURL, String cookieValue) {
        Cookie[] cookies;
        try {
            String host = hostURL.getHost();
            int port = hostURL.getPort();
            if (port == -1) {
                port = 80;
            }
            String path = hostURL.getPath();
            boolean secure = hostURL.getProtocol().endsWith("s");
            for (Cookie cookie : cookies = cookieParser.parse(host, port, path, secure, cookieValue)) {
                cookieParser.validate(host, port, path, secure, cookie);
            }
        }
        catch (MalformedCookieException e) {
            throw new IllegalArgumentException("Malformed cookie: " + cookieValue);
        }
        return cookies;
    }

    public static javax.servlet.http.Cookie convertFrom(Cookie cookie) {
        long maxAgeLong;
        if (cookie == null) {
            return null;
        }
        javax.servlet.http.Cookie result = new javax.servlet.http.Cookie(cookie.getName(), cookie.getValue());
        result.setComment(cookie.getComment());
        result.setDomain(cookie.getDomain());
        Date expiryDate = cookie.getExpiryDate();
        int maxAge = expiryDate != null ? ((maxAgeLong = expiryDate.getTime() - new Date().getTime()) >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)maxAgeLong) : -1;
        result.setMaxAge(maxAge);
        result.setPath(cookie.getPath());
        result.setSecure(cookie.getSecure());
        result.setVersion(cookie.getVersion());
        return result;
    }
}

