/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.expressions;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JsonELResolver
extends ELResolver {
    JsonELResolver() {
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base instanceof JSONArray) {
            return Integer.class;
        }
        if (base instanceof JSONObject) {
            return String.class;
        }
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (this.isJson(base)) {
            context.setPropertyResolved(true);
            Object value = this.getValue(context, base, property);
            return value == null ? null : value.getClass();
        }
        return null;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (base instanceof JSONObject) {
            context.setPropertyResolved(true);
            return ((JSONObject)base).opt(String.valueOf(property));
        }
        if (base instanceof JSONArray) {
            context.setPropertyResolved(true);
            int index = this.toInt(property);
            return ((JSONArray)base).opt(index);
        }
        return null;
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (this.isJson(base)) {
            context.setPropertyResolved(true);
        }
        return false;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (base instanceof JSONObject) {
            context.setPropertyResolved(true);
            try {
                ((JSONObject)base).put(String.valueOf(property), value);
            }
            catch (JSONException e) {
                throw new ELException((Throwable)e);
            }
            context.setPropertyResolved(true);
        }
        if (base instanceof JSONArray) {
            context.setPropertyResolved(true);
            int index = this.toInt(property);
            try {
                ((JSONArray)base).put(index, value);
            }
            catch (JSONException e) {
                throw new ELException((Throwable)e);
            }
            context.setPropertyResolved(true);
        }
    }

    private int toInt(Object property) {
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        try {
            return Integer.parseInt(String.valueOf(property));
        }
        catch (NumberFormatException nfe) {
            throw new ELException((Throwable)nfe);
        }
    }

    private boolean isJson(Object base) {
        return base instanceof JSONObject || base instanceof JSONArray;
    }
}

