/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl.fs;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;

public class FileNameProducer {
    private String serviceDir;
    private String backupSetName;
    private File backupSetDir;
    private boolean isFullBackup;
    private Calendar timeStamp;

    public FileNameProducer(String backupSetName, String serviceDir, Calendar timeStamp, boolean isFullBackup) {
        this.backupSetName = backupSetName;
        this.serviceDir = serviceDir;
        this.isFullBackup = isFullBackup;
        this.timeStamp = timeStamp;
    }

    public FileNameProducer(String repositoryName, String workspaceName, String serviceDir, Calendar timeStamp, boolean isFullBackup) {
        this.backupSetName = repositoryName + "_" + workspaceName;
        this.serviceDir = serviceDir;
        this.isFullBackup = isFullBackup;
        this.timeStamp = timeStamp;
    }

    public File getNextFile() {
        File nextFile = null;
        try {
            String sTime = "-" + FileNameProducer.getStrDate(this.timeStamp) + "_" + FileNameProducer.getStrTime(this.timeStamp);
            this.backupSetDir = new File(this.serviceDir + File.separator + this.backupSetName + sTime);
            if (!this.backupSetDir.exists()) {
                this.backupSetDir.mkdirs();
            }
            String sNextName = this.generateName();
            nextFile = new File(this.backupSetDir.getAbsoluteFile() + File.separator + sNextName);
            nextFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return nextFile;
    }

    private String generateName() {
        Calendar date = Calendar.getInstance();
        String sDate = FileNameProducer.getStrDate(date);
        String sTime = FileNameProducer.getStrTime(date);
        String fileName = this.backupSetName + "-" + sDate + "_" + sTime + ".";
        fileName = this.isFullBackup ? fileName + "0" : fileName + this.getNextSufix();
        return fileName;
    }

    private String getNextSufix() {
        String[] fileList = this.backupSetDir.list();
        int sufix = 0;
        for (int i = 0; i < fileList.length; ++i) {
            String[] stringArray = fileList[i].split("[.]");
            int currentSufix = Integer.valueOf(stringArray[stringArray.length - 1]);
            if (currentSufix <= sufix) continue;
            sufix = currentSufix;
        }
        return String.valueOf(++sufix);
    }

    public static String getStrDate(Calendar c) {
        int m = c.get(2) + 1;
        int d = c.get(5);
        return "" + c.get(1) + (m < 10 ? "0" + m : Integer.valueOf(m)) + (d < 10 ? "0" + d : Integer.valueOf(d));
    }

    public static String getStrTime(Calendar c) {
        int h = c.get(10);
        int m = c.get(12);
        int s = c.get(13);
        return "" + (h < 10 ? "0" + h : Integer.valueOf(h)) + (m < 10 ? "0" + m : Integer.valueOf(m)) + (s < 10 ? "0" + s : Integer.valueOf(s));
    }
}

