/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.util.jdbc.cleaner;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.storage.jdbc.DBConstants;
import org.exoplatform.services.jcr.impl.storage.jdbc.DialectDetecter;
import org.exoplatform.services.jcr.impl.util.jdbc.cleaner.DBCleaner;
import org.exoplatform.services.jcr.impl.util.jdbc.cleaner.DBCleanerException;
import org.exoplatform.services.jcr.impl.util.jdbc.cleaner.HSQLSingleDBCleaner;
import org.exoplatform.services.jcr.impl.util.jdbc.cleaner.IngresSQLMultiDBCleaner;
import org.exoplatform.services.jcr.impl.util.jdbc.cleaner.IngresSQLSingleDBCleaner;
import org.exoplatform.services.jcr.impl.util.jdbc.cleaner.MultiDBCleaner;
import org.exoplatform.services.jcr.impl.util.jdbc.cleaner.OracleMultiDBCleaner;
import org.exoplatform.services.jcr.impl.util.jdbc.cleaner.OracleSingleDBCleaner;
import org.exoplatform.services.jcr.impl.util.jdbc.cleaner.PgSQLMultiDBCleaner;
import org.exoplatform.services.jcr.impl.util.jdbc.cleaner.PgSQLSingleDBCleaner;
import org.exoplatform.services.jcr.impl.util.jdbc.cleaner.SingleDBCleaner;
import org.exoplatform.services.jcr.impl.util.jdbc.cleaner.WorkspaceDBCleaner;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DBCleanerService {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.DBCleanerService");

    public void cleanWorkspaceData(WorkspaceEntry wsEntry) throws DBCleanerException {
        this.getDBCleaner(wsEntry).clean();
    }

    public void cleanRepositoryData(RepositoryEntry repoEntry) throws DBCleanerException {
        SecurityManager security = System.getSecurityManager();
        for (WorkspaceEntry wsEntry : repoEntry.getWorkspaceEntries()) {
            this.getDBCleaner(wsEntry).clean();
        }
    }

    private DBCleaner getDBCleaner(WorkspaceEntry wsEntry) throws DBCleanerException {
        String dbDialect;
        DataSource ds;
        boolean isMultiDb;
        String sourceName;
        try {
            sourceName = wsEntry.getContainer().getParameterValue("source-name");
            if (sourceName == null) {
                throw new RepositoryConfigurationException("Parameter source-name not found in workspace configuration " + wsEntry.getName());
            }
        }
        catch (RepositoryConfigurationException e) {
            throw new DBCleanerException("Can't define source-name parameter", e);
        }
        try {
            String multiDb = wsEntry.getContainer().getParameterValue("multi-db");
            if (multiDb == null) {
                throw new RepositoryConfigurationException("Parameter multi-db not found in workspace configuration " + wsEntry.getName());
            }
            isMultiDb = Boolean.parseBoolean(multiDb);
        }
        catch (RepositoryConfigurationException e) {
            throw new DBCleanerException("Can't define multi-db parameter", e);
        }
        try {
            ds = (DataSource)new InitialContext().lookup(sourceName);
        }
        catch (NamingException e) {
            throw new DBCleanerException("Can't define data source " + sourceName, e);
        }
        Connection conn = null;
        try {
            DataSource fds = ds;
            conn = fds.getConnection();
        }
        catch (SQLException e) {
            throw new DBCleanerException("Can't open JDBC connection", e);
        }
        try {
            dbDialect = DialectDetecter.detect(conn.getMetaData());
        }
        catch (SQLException e) {
            throw new DBCleanerException("Can't define DB dialect", e);
        }
        WorkspaceDBCleaner dbCleaner = isMultiDb ? (dbDialect == DBConstants.DB_DIALECT_ORACLEOCI || dbDialect == DBConstants.DB_DIALECT_ORACLE ? new OracleMultiDBCleaner(wsEntry, conn) : (dbDialect == DBConstants.DB_DIALECT_PGSQL ? new PgSQLMultiDBCleaner(wsEntry, conn) : (dbDialect == DBConstants.DB_DIALECT_INGRES ? new IngresSQLMultiDBCleaner(wsEntry, conn) : new MultiDBCleaner(wsEntry, conn)))) : (dbDialect == DBConstants.DB_DIALECT_ORACLEOCI || dbDialect == DBConstants.DB_DIALECT_ORACLE ? new OracleSingleDBCleaner(wsEntry, conn) : (dbDialect == DBConstants.DB_DIALECT_PGSQL ? new PgSQLSingleDBCleaner(wsEntry, conn) : (dbDialect == DBConstants.DB_DIALECT_INGRES ? new IngresSQLSingleDBCleaner(wsEntry, conn) : (dbDialect == DBConstants.DB_DIALECT_HSQLDB ? new HSQLSingleDBCleaner(wsEntry, conn) : new SingleDBCleaner(wsEntry, conn)))));
        return dbCleaner;
    }
}

