/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database.creator;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.Property;
import org.exoplatform.services.database.creator.DBConnectionInfo;
import org.exoplatform.services.database.creator.DBCreatorException;

public class DBCreator {
    private static final String DB_CONNECTION = "db-connection";
    private static final String DB_DRIVER = "driverClassName";
    private static final String DB_URL = "url";
    private static final String DB_USERNAME = "username";
    private static final String DB_PASSWORD = "password";
    private static final String DB_ORCL_INTERNAL_LOGON = "internal_logon";
    private static final String DB_CREATION = "db-creation";
    private static final String DB_SCRIPT_PATH = "scriptPath";
    public static final String DATABASE_TEMPLATE = "${database}";
    public static final String USERNAME_TEMPLATE = "${username}";
    public static final String PASSWORD_TEMPLATE = "${password}";
    protected final String serverUrl;
    protected final Map<String, String> connectionProperties;
    protected final String dbScript;
    protected final String dbUserName;
    protected final String dbPassword;

    public DBCreator(InitParams params) throws ConfigurationException {
        if (params == null) {
            throw new ConfigurationException("Initializations parameters expected");
        }
        PropertiesParam prop = params.getPropertiesParam(DB_CONNECTION);
        if (prop != null) {
            if (prop.getProperty(DB_DRIVER) == null) {
                throw new ConfigurationException("driverClassName expected in db-connection properties section");
            }
            this.serverUrl = prop.getProperty(DB_URL);
            if (this.serverUrl == null) {
                throw new ConfigurationException("url expected in db-connection properties section");
            }
            if (prop.getProperty(DB_USERNAME) == null) {
                throw new ConfigurationException("username expected in db-connection properties section");
            }
            if (prop.getProperty(DB_PASSWORD) == null) {
                throw new ConfigurationException("password expected in db-connection properties section");
            }
            Iterator pit = prop.getPropertyIterator();
            this.connectionProperties = new HashMap<String, String>();
            while (pit.hasNext()) {
                Property p = (Property)pit.next();
                if (p.getName().equalsIgnoreCase(DB_URL)) continue;
                this.connectionProperties.put(p.getName(), p.getValue());
            }
        } else {
            throw new ConfigurationException("db-connection properties expected in initializations parameters");
        }
        prop = params.getPropertiesParam(DB_CREATION);
        if (prop != null) {
            String scriptPath = prop.getProperty(DB_SCRIPT_PATH);
            if (scriptPath != null) {
                try {
                    this.dbScript = this.readScriptResource(scriptPath);
                }
                catch (IOException e) {
                    throw new ConfigurationException("Can't read script resource " + scriptPath, (Throwable)e);
                }
            } else {
                throw new ConfigurationException("scriptPath expected in db-creation properties section");
            }
            this.dbUserName = prop.getProperty(DB_USERNAME);
            if (this.dbUserName == null) {
                throw new ConfigurationException("username expected in db-creation properties section");
            }
            this.dbPassword = prop.getProperty(DB_PASSWORD);
            if (this.dbPassword == null) {
                throw new ConfigurationException("password expected in db-creation properties section");
            }
        } else {
            throw new ConfigurationException("db-creation properties expected in initializations parameters");
        }
    }

    public DBConnectionInfo createDatabase(String dbName) throws DBCreatorException {
        String dbProductName;
        Connection conn = null;
        try {
            Class.forName(this.connectionProperties.get(DB_DRIVER));
            conn = (Connection)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Connection>(){

                @Override
                public Connection run() throws Exception {
                    return DriverManager.getConnection(DBCreator.this.serverUrl, DBCreator.this.connectionProperties.get(DBCreator.DB_USERNAME), DBCreator.this.connectionProperties.get(DBCreator.DB_PASSWORD));
                }
            });
        }
        catch (SQLException e) {
            throw new DBCreatorException("Can't establish the JDBC connection to database " + this.serverUrl, e);
        }
        catch (ClassNotFoundException e) {
            throw new DBCreatorException("Can't load the JDBC driver " + this.connectionProperties.get(DB_DRIVER), e);
        }
        try {
            final Connection connection = conn;
            dbProductName = (String)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return connection.getMetaData().getDatabaseProductName();
                }
            });
            if (dbProductName.startsWith("Microsoft SQL Server") || dbProductName.startsWith("Adaptive Server Anywhere") || dbProductName.equals("Sybase SQL Server") || dbProductName.equals("Adaptive Server Enterprise")) {
                this.executeAutoCommitMode(conn, dbName);
            } else {
                this.executeBatchMode(conn, dbName);
            }
        }
        catch (SQLException e) {
            String errorTrace = "";
            while (e != null) {
                errorTrace = errorTrace + e.getMessage() + "; ";
                e = e.getNextException();
            }
            throw new DBCreatorException("Can't execute SQL script " + errorTrace);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new DBCreatorException("Can't close connection", e);
            }
        }
        return this.constructDBConnectionInfo(dbName, dbProductName);
    }

    public DBConnectionInfo getDBConnectionInfo(String dbName) throws DBCreatorException {
        String dbProductName;
        Connection conn = null;
        try {
            Class.forName(this.connectionProperties.get(DB_DRIVER));
            conn = (Connection)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Connection>(){

                @Override
                public Connection run() throws Exception {
                    return DriverManager.getConnection(DBCreator.this.serverUrl, DBCreator.this.connectionProperties.get(DBCreator.DB_USERNAME), DBCreator.this.connectionProperties.get(DBCreator.DB_PASSWORD));
                }
            });
        }
        catch (SQLException e) {
            throw new DBCreatorException("Can't establish the JDBC connection to database " + this.serverUrl, e);
        }
        catch (ClassNotFoundException e) {
            throw new DBCreatorException("Can't load the JDBC driver " + this.connectionProperties.get(DB_DRIVER), e);
        }
        try {
            final Connection connection = conn;
            dbProductName = (String)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return connection.getMetaData().getDatabaseProductName();
                }
            });
        }
        catch (SQLException e) {
            throw new DBCreatorException("Can't resolve database product name ", e);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new DBCreatorException("Can't close connection", e);
            }
        }
        return this.constructDBConnectionInfo(dbName, dbProductName);
    }

    private void executeBatchMode(Connection conn, String dbName) throws SQLException {
        Statement statement = conn.createStatement();
        for (String scr : this.dbScript.split(";")) {
            scr = scr.replace(DATABASE_TEMPLATE, dbName);
            scr = scr.replace(USERNAME_TEMPLATE, this.dbUserName);
            String s = this.cleanWhitespaces((scr = scr.replace(PASSWORD_TEMPLATE, this.dbPassword)).trim());
            if (s.length() <= 0) continue;
            statement.addBatch(s);
        }
        statement.executeBatch();
    }

    private DBConnectionInfo constructDBConnectionInfo(String dbName, String dbProductName) {
        String dbUrl = this.serverUrl;
        if (dbProductName.startsWith("Microsoft SQL Server")) {
            dbUrl = dbUrl + (dbUrl.endsWith(";") ? "" : ";") + "databaseName=" + dbName + ";";
        } else if (!dbProductName.equals("Oracle")) {
            dbUrl = dbUrl + (dbUrl.endsWith("/") ? "" : "/") + dbName;
        }
        HashMap<String, String> connProperties = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.connectionProperties.entrySet()) {
            connProperties.put(entry.getKey(), entry.getValue());
        }
        connProperties.put(DB_URL, dbUrl);
        return new DBConnectionInfo(connProperties);
    }

    private void executeAutoCommitMode(Connection conn, String dbName) throws SQLException {
        conn.setAutoCommit(true);
        for (String scr : this.dbScript.split(";")) {
            scr = scr.replace(DATABASE_TEMPLATE, dbName);
            scr = scr.replace(USERNAME_TEMPLATE, this.dbUserName);
            String s = this.cleanWhitespaces((scr = scr.replace(PASSWORD_TEMPLATE, this.dbPassword)).trim());
            if (s.length() <= 0) continue;
            conn.createStatement().executeUpdate(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readScriptResource(String path) throws IOException {
        FileInputStream is = PrivilegedFileHelper.fileInputStream((String)path);
        InputStreamReader isr = new InputStreamReader(is);
        try {
            StringBuilder sbuff = new StringBuilder();
            char[] buff = new char[((InputStream)is).available()];
            int r = 0;
            while ((r = isr.read(buff)) > 0) {
                sbuff.append(buff, 0, r);
            }
            String string = sbuff.toString();
            return string;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private String cleanWhitespaces(String string) {
        if (string != null) {
            char[] cc = string.toCharArray();
            for (int ci = cc.length - 1; ci > 0; --ci) {
                if (!Character.isWhitespace(cc[ci])) continue;
                cc[ci] = 32;
            }
            return new String(cc);
        }
        return string;
    }
}

