/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml.importing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataRemoveVisitor;
import org.exoplatform.services.jcr.impl.dataflow.version.VersionHistoryDataHelper;
import org.exoplatform.services.jcr.impl.xml.VersionHistoryRemover;
import org.exoplatform.services.jcr.impl.xml.importing.ContentImporter;
import org.exoplatform.services.jcr.impl.xml.importing.dataflow.ImportItemData;
import org.exoplatform.services.jcr.impl.xml.importing.dataflow.ImportNodeData;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseXmlImporter
implements ContentImporter {
    private static final String SESSION_ID = "00base0xml0importer0session0id00";
    protected final AccessManager accessManager;
    protected QPath ancestorToSave;
    protected final PlainChangesLogImpl changesLog;
    protected final Map<String, Object> context;
    protected final String currentWorkspaceName;
    protected final ItemDataConsumer dataConsumer;
    protected boolean isNeedReloadAncestorToSave;
    protected final LocationFactory locationFactory;
    protected final NamespaceRegistry namespaceRegistry;
    protected final NodeTypeDataManager nodeTypeDataManager;
    protected final RepositoryImpl repository;
    protected final Stack<NodeData> tree;
    protected final ConversationState userState;
    protected final int uuidBehavior;
    protected final ValueFactoryImpl valueFactory;
    private final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.ImporterBase");

    public BaseXmlImporter(NodeData parent, QPath ancestorToSave, int uuidBehavior, ItemDataConsumer dataConsumer, NodeTypeDataManager ntManager, LocationFactory locationFactory, ValueFactoryImpl valueFactory, NamespaceRegistry namespaceRegistry, AccessManager accessManager, ConversationState userState, Map<String, Object> context, RepositoryImpl repository, String currentWorkspaceName) {
        this.dataConsumer = dataConsumer;
        this.valueFactory = valueFactory;
        this.namespaceRegistry = namespaceRegistry;
        this.accessManager = accessManager;
        this.userState = userState;
        this.context = context;
        this.nodeTypeDataManager = ntManager;
        this.locationFactory = locationFactory;
        this.uuidBehavior = uuidBehavior;
        this.repository = repository;
        this.currentWorkspaceName = currentWorkspaceName;
        this.tree = new Stack();
        this.tree.push(parent);
        this.changesLog = new PlainChangesLogImpl(SESSION_ID);
        this.ancestorToSave = ancestorToSave;
        this.isNeedReloadAncestorToSave = false;
    }

    public QPath getAncestorToSave() {
        return this.ancestorToSave;
    }

    @Override
    public PlainChangesLog getChanges() {
        Collections.sort(this.changesLog.getAllStates(), new PathSorter());
        if (this.log.isDebugEnabled()) {
            String str = "";
            for (int i = 0; i < this.changesLog.getAllStates().size(); ++i) {
                str = str + " " + ItemState.nameFromValue(this.changesLog.getAllStates().get(i).getState()) + "\t\t" + this.changesLog.getAllStates().get(i).getData().getIdentifier() + "\t" + "isPersisted=" + this.changesLog.getAllStates().get(i).isPersisted() + "\t" + "isEventFire=" + this.changesLog.getAllStates().get(i).isEventFire() + "\t" + "isInternallyCreated=" + this.changesLog.getAllStates().get(i).isInternallyCreated() + "\t" + this.changesLog.getAllStates().get(i).getData().getQPath().getAsString() + "\n";
            }
            this.log.debug((Object)str);
        }
        if (this.isNeedReloadAncestorToSave) {
            PlainChangesLogImpl newChangesLog = new PlainChangesLogImpl();
            for (ItemState itemState : this.changesLog.getAllStates()) {
                newChangesLog.add(new ItemState(itemState.getData(), itemState.getState(), itemState.isEventFire(), this.ancestorToSave, itemState.isInternallyCreated(), itemState.isPersisted(), itemState.getOldPath()));
            }
            this.changesLog.clear();
            this.changesLog.addAll(newChangesLog.getAllStates());
            this.isNeedReloadAncestorToSave = false;
        }
        return this.changesLog;
    }

    public int getNextChildOrderNum(NodeData parentData) {
        int max = -1;
        for (ItemState itemState : this.changesLog.getAllStates()) {
            int cur;
            ItemData stateData = itemState.getData();
            if (!this.isParent(stateData, parentData) || !stateData.isNode() || (cur = ((NodeData)stateData).getOrderNumber()) <= max) continue;
            max = cur;
        }
        return ++max;
    }

    public int getNodeIndex(NodeData parentData, InternalQName name, String skipIdentifier) throws PathNotFoundException, IllegalPathException, RepositoryException {
        int newIndex = 1;
        NodeDefinitionData nodedef = this.nodeTypeDataManager.getChildNodeDefinition(name, parentData.getPrimaryTypeName(), parentData.getMixinTypeNames());
        ItemData sameNameNode = null;
        try {
            sameNameNode = this.dataConsumer.getItemData(parentData, new QPathEntry(name, 0), ItemType.NODE);
        }
        catch (PathNotFoundException e) {
            return newIndex;
        }
        List<ItemState> transientAddChilds = this.getItemStatesList(parentData, name, 1, skipIdentifier);
        List<ItemState> transientDeletedChilds = this.getItemStatesList(parentData, new QPathEntry(name, 0), 4, null);
        if (!(nodedef.isAllowsSameNameSiblings() || sameNameNode == null && transientAddChilds.size() <= 0)) {
            if (sameNameNode != null && transientDeletedChilds.size() < 1) {
                throw new ItemExistsException("The node  already exists in " + sameNameNode.getQPath().getAsString() + " and same name sibling is not allowed ");
            }
            if (transientAddChilds.size() > 0) {
                throw new ItemExistsException("The node  already exists in add state   and same name sibling is not allowed ");
            }
        }
        newIndex += transientAddChilds.size();
        List<NodeData> existedChilds = this.dataConsumer.getChildNodesData(parentData);
        for (NodeData child : existedChilds) {
            if (transientDeletedChilds.size() != 0 || !child.getQPath().getName().equals((Object)name)) continue;
            ++newIndex;
        }
        return newIndex;
    }

    @Override
    public void registerNamespace(String prefix, String uri) {
        try {
            this.namespaceRegistry.getPrefix(uri);
        }
        catch (NamespaceException e) {
            try {
                this.namespaceRegistry.registerNamespace(prefix, uri);
            }
            catch (NamespaceException e1) {
                throw new RuntimeException(e1);
            }
            catch (RepositoryException e1) {
                throw new RuntimeException(e1);
            }
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public void setAncestorToSave(QPath newAncestorToSave) {
        if (!this.ancestorToSave.equals(newAncestorToSave)) {
            this.isNeedReloadAncestorToSave = true;
        }
        this.ancestorToSave = newAncestorToSave;
    }

    protected void createVersionHistory(ImportNodeData nodeData) throws RepositoryException {
        boolean newVersionHistory;
        boolean bl = newVersionHistory = nodeData.isNewIdentifer() || !nodeData.isContainsVersionhistory();
        if (newVersionHistory) {
            nodeData.setVersionHistoryIdentifier(IdGenerator.generate());
            nodeData.setBaseVersionIdentifier(IdGenerator.generate());
        }
        PlainChangesLogImpl changes = new PlainChangesLogImpl();
        new VersionHistoryDataHelper(nodeData, changes, this.dataConsumer, this.nodeTypeDataManager, nodeData.getVersionHistoryIdentifier(), nodeData.getBaseVersionIdentifier());
        if (this.uuidBehavior == 2 && !newVersionHistory) {
            for (ItemState state : changes.getAllStates()) {
                if (state.getData().getQPath().isDescendantOf(Constants.JCR_SYSTEM_PATH)) continue;
                this.changesLog.add(state);
            }
        } else {
            this.changesLog.addAll(changes.getAllStates());
        }
    }

    protected NodeData getParent() {
        return this.tree.peek();
    }

    protected void checkReferenceable(ImportNodeData currentNodeInfo, String olUuid) throws RepositoryException {
        if (Constants.JCR_VERSION_STORAGE_PATH.getDepth() + 3 <= currentNodeInfo.getQPath().getDepth() && currentNodeInfo.getQPath().getEntries()[Constants.JCR_VERSION_STORAGE_PATH.getDepth() + 3].equals((Object)Constants.JCR_FROZENNODE) && currentNodeInfo.getQPath().isDescendantOf(Constants.JCR_VERSION_STORAGE_PATH)) {
            return;
        }
        String identifier = this.validateUuidCollision(olUuid);
        if (identifier != null) {
            this.reloadChangesInfoAfterUC(currentNodeInfo, identifier);
        } else {
            currentNodeInfo.setIsNewIdentifer(true);
        }
        if (this.uuidBehavior == 2) {
            currentNodeInfo.setParentIdentifer(this.getParent().getIdentifier());
        }
    }

    protected void reloadChangesInfoAfterUC(ImportNodeData currentNodeInfo, String identifier) throws PathNotFoundException, IllegalPathException, RepositoryException {
        boolean reloadSNS = this.uuidBehavior == 1 || this.uuidBehavior == 2;
        QPath newPath = null;
        if (reloadSNS) {
            NodeData currentParentData = this.getParent();
            int nodeIndex = this.getNodeIndex(currentParentData, currentNodeInfo.getQName(), currentNodeInfo.getIdentifier());
            newPath = QPath.makeChildPath(currentParentData.getQPath(), currentNodeInfo.getQName(), nodeIndex);
            currentNodeInfo.setQPath(newPath);
        }
        String oldIdentifer = currentNodeInfo.getIdentifier();
        for (ItemState state : this.changesLog.getAllStates()) {
            ItemData data = state.getData();
            if (data.getParentIdentifier() == null || !data.getParentIdentifier().equals(oldIdentifer)) continue;
            ((ImportItemData)((Object)data)).setParentIdentifer(identifier);
            if (!reloadSNS) continue;
            ((ImportItemData)((Object)data)).setQPath(QPath.makeChildPath(newPath, data.getQPath().getName()));
        }
        currentNodeInfo.setIdentifier(identifier);
    }

    protected AccessControlList initAcl(AccessControlList parentACL, boolean isOwneable, boolean isPrivilegeable, String owner, List<String> exoPermissions) {
        AccessControlList acl = isOwneable ? (isPrivilegeable ? new AccessControlList(owner, this.readACLPermisions(exoPermissions)) : (parentACL != null ? new AccessControlList(owner, parentACL.hasPermissions() ? parentACL.getPermissionEntries() : null) : new AccessControlList(owner, null))) : (isPrivilegeable ? (isOwneable ? new AccessControlList(owner, this.readACLPermisions(exoPermissions)) : (parentACL != null ? new AccessControlList(parentACL.getOwner(), this.readACLPermisions(exoPermissions)) : new AccessControlList(null, this.readACLPermisions(exoPermissions)))) : (parentACL != null ? new AccessControlList(parentACL.getOwner(), parentACL.hasPermissions() ? parentACL.getPermissionEntries() : null) : null));
        return acl;
    }

    protected List<AccessControlEntry> readACLPermisions(List<String> exoPermissions) {
        ArrayList<AccessControlEntry> naPermissions = new ArrayList<AccessControlEntry>();
        for (String perm : exoPermissions) {
            StringTokenizer parser = new StringTokenizer(perm, " ");
            naPermissions.add(new AccessControlEntry(parser.nextToken(), parser.nextToken()));
        }
        return naPermissions;
    }

    protected String validateUuidCollision(String identifier) throws RepositoryException {
        String newIdentifer = identifier;
        if (identifier != null) {
            try {
                NodeData sameUuidItem = (NodeData)this.dataConsumer.getItemData(identifier);
                ItemState lastState = this.getLastItemState(identifier);
                if (!(sameUuidItem == null || lastState != null && lastState.isDeleted())) {
                    boolean isMixVersionable = this.nodeTypeDataManager.isNodeType(Constants.MIX_VERSIONABLE, sameUuidItem.getMixinTypeNames());
                    switch (this.uuidBehavior) {
                        case 0: {
                            newIdentifer = null;
                            break;
                        }
                        case 1: {
                            if (isMixVersionable) {
                                this.removeVersionHistory(sameUuidItem);
                            }
                            this.removeExisted(sameUuidItem);
                            break;
                        }
                        case 2: {
                            this.removeExisted(sameUuidItem);
                            ItemData parentOfsameUuidItem = this.dataConsumer.getItemData(sameUuidItem.getParentIdentifier());
                            this.tree.push(ImportNodeData.createCopy((NodeData)parentOfsameUuidItem));
                            break;
                        }
                        case 3: {
                            throw new ItemExistsException("An incoming referenceable node has the same UUID as a node already existing in the workspace!");
                        }
                    }
                }
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
        }
        return newIdentifer;
    }

    private List<ItemState> getItemStatesList(NodeData parentData, InternalQName name, int state, String skipIdentifier) {
        ArrayList<ItemState> states = new ArrayList<ItemState>();
        for (ItemState itemState : this.changesLog.getAllStates()) {
            ItemData stateData = itemState.getData();
            if (!this.isParent(stateData, parentData) || !stateData.getQPath().getName().equals((Object)name) || state != 0 && state != itemState.getState() || stateData.getIdentifier().equals(skipIdentifier)) continue;
            states.add(itemState);
        }
        return states;
    }

    private ItemState getLastItemState(String identifer) {
        List<ItemState> allStates = this.changesLog.getAllStates();
        for (int i = allStates.size() - 1; i >= 0; --i) {
            ItemState state = allStates.get(i);
            if (!state.getData().getIdentifier().equals(identifer)) continue;
            return state;
        }
        return null;
    }

    private boolean isParent(ItemData data, ItemData parent) {
        String id2;
        String id1 = data.getParentIdentifier();
        if (id1 == (id2 = parent.getIdentifier())) {
            return true;
        }
        if (id1 == null && id2 != null) {
            return false;
        }
        return id1.equals(id2);
    }

    private void removeExisted(NodeData sameUuidItem) throws RepositoryException, ConstraintViolationException, PathNotFoundException {
        if (!this.nodeTypeDataManager.isNodeType(Constants.MIX_REFERENCEABLE, sameUuidItem.getPrimaryTypeName(), sameUuidItem.getMixinTypeNames())) {
            throw new RepositoryException("An incoming referenceable node has the same  UUID as a identifier of non mix:referenceable node already existing in the workspace!");
        }
        QPath sameUuidPath = sameUuidItem.getQPath();
        if (this.ancestorToSave.isDescendantOf(sameUuidPath) || this.ancestorToSave.equals(sameUuidPath)) {
            throw new ConstraintViolationException("The imported document contains a element with jcr:uuid attribute the same as the  parent of the import target.");
        }
        this.setAncestorToSave(QPath.getCommonAncestorPath(this.ancestorToSave, sameUuidPath));
        ItemDataRemoveVisitor visitor = new ItemDataRemoveVisitor(this.dataConsumer, this.getAncestorToSave(), this.nodeTypeDataManager, this.accessManager, this.userState);
        sameUuidItem.accept(visitor);
        this.changesLog.addAll(visitor.getRemovedStates());
    }

    private void removeVersionHistory(NodeData mixVersionableNode) throws RepositoryException, ConstraintViolationException, VersionException {
        try {
            PropertyData vhpd = (PropertyData)this.dataConsumer.getItemData(mixVersionableNode, new QPathEntry(Constants.JCR_VERSIONHISTORY, 1), ItemType.PROPERTY);
            try {
                String vhID = new String(vhpd.getValues().get(0).getAsByteArray());
                VersionHistoryRemover historyRemover = new VersionHistoryRemover(vhID, this.dataConsumer, this.nodeTypeDataManager, this.repository, this.currentWorkspaceName, null, this.ancestorToSave, this.changesLog, this.accessManager, this.userState);
                historyRemover.remove();
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        catch (IllegalStateException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PathSorter
    implements Comparator<ItemState> {
        private PathSorter() {
        }

        @Override
        public int compare(ItemState i1, ItemState i2) {
            int sign = 0;
            if (i1.getState() != i2.getState()) {
                sign = i2.isDeleted() ? 1 : -1;
            }
            return sign;
        }
    }
}

