/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.logging;

import org.jgroups.logging.CustomLogFactory;
import org.jgroups.logging.JDKLogImpl;
import org.jgroups.logging.Log;
import org.jgroups.logging.Log4JLogImpl;

public class LogFactory {
    public static final boolean IS_LOG4J_AVAILABLE;
    private static final CustomLogFactory custom_log_factory;

    public static Log getLog(Class clazz) {
        if (custom_log_factory != null) {
            return custom_log_factory.getLog(clazz);
        }
        boolean use_jdk_logger = Boolean.parseBoolean(System.getProperty("jgroups.use.jdk_logger"));
        if (IS_LOG4J_AVAILABLE && !use_jdk_logger) {
            return new Log4JLogImpl(clazz);
        }
        return new JDKLogImpl(clazz);
    }

    public static Log getLog(String category) {
        if (custom_log_factory != null) {
            return custom_log_factory.getLog(category);
        }
        boolean use_jdk_logger = Boolean.parseBoolean(System.getProperty("jgroups.use.jdk_logger"));
        if (IS_LOG4J_AVAILABLE && !use_jdk_logger) {
            return new Log4JLogImpl(category);
        }
        return new JDKLogImpl(category);
    }

    static {
        boolean available;
        String customLogFactoryClass = System.getProperty("jgroups.logging.log_factory_class");
        CustomLogFactory customLogFactoryX = null;
        if (customLogFactoryClass != null) {
            try {
                customLogFactoryX = (CustomLogFactory)Class.forName(customLogFactoryClass).newInstance();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        custom_log_factory = customLogFactoryX;
        try {
            Class.forName("org.apache.log4j.Logger");
            available = true;
        }
        catch (ClassNotFoundException cnfe) {
            available = false;
        }
        IS_LOG4J_AVAILABLE = available;
    }
}

