/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.exoplatform.commons.utils.SecurityHelper;

public class MimeTypeResolver {
    private Map<String, List<String>> mimeTypes = new HashMap<String, List<String>>();
    private Map<String, List<String>> extentions = new HashMap<String, List<String>>();
    private String defaultMimeType = "application/octet-stream";

    public MimeTypeResolver() {
        try {
            SecurityHelper.doPrivilegedIOExceptionAction(new PrivilegedExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() throws Exception {
                    Scanner scanner = new Scanner(this.getClass().getResourceAsStream("mimetypes.properties"), "ISO-8859-1");
                    try {
                        while (scanner.hasNextLine()) {
                            MimeTypeResolver.this.processLine(scanner.nextLine());
                        }
                    }
                    finally {
                        scanner.close();
                    }
                    return null;
                }
            });
        }
        catch (IOException e) {
            throw new InternalError("Unable to load mimetypes: " + e.toString());
        }
    }

    public String getDefaultMimeType() {
        return this.defaultMimeType;
    }

    public void setDefaultMimeType(String defaultMimeType) {
        this.defaultMimeType = defaultMimeType;
    }

    public String getMimeType(String filename) {
        List<String> values;
        String ext = filename.substring(filename.lastIndexOf(".") + 1);
        if (ext.isEmpty()) {
            ext = filename;
        }
        return (values = this.mimeTypes.get(ext)) == null ? this.defaultMimeType : values.get(0);
    }

    public String getExtension(String mimeType) {
        if (mimeType.isEmpty() || mimeType.equals(this.defaultMimeType)) {
            return "";
        }
        List<String> values = this.extentions.get(mimeType);
        if (values == null) {
            return "";
        }
        String resultExt = "";
        for (String ext : values) {
            if (mimeType.endsWith(ext)) {
                return ext;
            }
            if (!resultExt.isEmpty()) continue;
            resultExt = ext;
        }
        return resultExt;
    }

    protected void processLine(String aLine) {
        int p = aLine.indexOf("=");
        String ext = aLine.substring(0, p);
        String mimetype = aLine.substring(p + 1);
        List<String> values = this.mimeTypes.get(ext);
        if (values == null) {
            values = new ArrayList<String>();
            this.mimeTypes.put(ext, values);
        }
        values.add(mimetype);
        values = this.extentions.get(mimetype);
        if (values == null) {
            values = new ArrayList<String>();
            this.extentions.put(mimetype, values);
        }
        values.add(ext);
    }
}

