/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectParser;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.ASN1TaggedObjectParser;
import org.bouncycastle.asn1.BEROctetStringParser;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERSequenceParser;
import org.bouncycastle.asn1.BERSetParser;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DefiniteLengthInputStream;
import org.bouncycastle.asn1.IndefiniteLengthInputStream;

public class BERTaggedObjectParser
implements ASN1TaggedObjectParser {
    private int _baseTag;
    private int _tagNumber;
    private InputStream _contentStream;
    private boolean _indefiniteLength;

    protected BERTaggedObjectParser(int n, int n2, InputStream inputStream) {
        this._baseTag = n;
        this._tagNumber = n2;
        this._contentStream = inputStream;
        this._indefiniteLength = inputStream instanceof IndefiniteLengthInputStream;
    }

    public boolean isConstructed() {
        return (this._baseTag & 0x20) != 0;
    }

    public int getTagNo() {
        return this._tagNumber;
    }

    public DEREncodable getObjectParser(int n, boolean bl) throws IOException {
        if (bl) {
            return new ASN1StreamParser(this._contentStream).readObject();
        }
        switch (n) {
            case 17: {
                if (this._indefiniteLength) {
                    return new BERSetParser(new ASN1ObjectParser(this._baseTag, this._tagNumber, this._contentStream));
                }
                return new DERSet(this.loadVector(this._contentStream)).parser();
            }
            case 16: {
                if (this._indefiniteLength) {
                    return new BERSequenceParser(new ASN1ObjectParser(this._baseTag, this._tagNumber, this._contentStream));
                }
                return new DERSequence(this.loadVector(this._contentStream)).parser();
            }
            case 4: {
                if (this._indefiniteLength || this.isConstructed()) {
                    return new BEROctetStringParser(new ASN1ObjectParser(this._baseTag, this._tagNumber, this._contentStream));
                }
                return new DEROctetString(((DefiniteLengthInputStream)this._contentStream).toByteArray()).parser();
            }
        }
        throw new RuntimeException("implicit tagging not implemented");
    }

    private ASN1EncodableVector loadVector(InputStream inputStream) throws IOException {
        ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(inputStream);
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        DEREncodable dEREncodable = aSN1StreamParser.readObject();
        while (dEREncodable != null) {
            aSN1EncodableVector.add(dEREncodable.getDERObject());
            dEREncodable = aSN1StreamParser.readObject();
        }
        return aSN1EncodableVector;
    }

    private ASN1EncodableVector rLoadVector(InputStream inputStream) {
        try {
            return this.loadVector(inputStream);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage());
        }
    }

    public DERObject getDERObject() {
        if (this._indefiniteLength) {
            ASN1EncodableVector aSN1EncodableVector = this.rLoadVector(this._contentStream);
            if (aSN1EncodableVector.size() > 1) {
                return new BERTaggedObject(false, this._tagNumber, new BERSequence(aSN1EncodableVector));
            }
            if (aSN1EncodableVector.size() == 1) {
                return new BERTaggedObject(true, this._tagNumber, aSN1EncodableVector.get(0));
            }
            return new BERTaggedObject(false, this._tagNumber, new BERSequence());
        }
        if (this.isConstructed()) {
            ASN1EncodableVector aSN1EncodableVector = this.rLoadVector(this._contentStream);
            if (aSN1EncodableVector.size() == 1) {
                return new DERTaggedObject(true, this._tagNumber, aSN1EncodableVector.get(0));
            }
            return new DERTaggedObject(false, this._tagNumber, new DERSequence(aSN1EncodableVector));
        }
        try {
            return new DERTaggedObject(false, this._tagNumber, new DEROctetString(((DefiniteLengthInputStream)this._contentStream).toByteArray()));
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage());
        }
    }
}

