/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.portal.application.PortalRequestHandler;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.mop.user.UserPortalContext;
import org.exoplatform.portal.url.PortalURLContext;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.url.MimeType;
import org.exoplatform.web.url.URLContext;
import org.exoplatform.web.url.URLFactoryService;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;

public class LegacyRequestHandler
extends WebRequestHandler {
    private final URLFactoryService urlFactory;
    private final UserPortalConfigService userPortalService;
    private final UserPortalContext userPortalContext = new UserPortalContext(){

        public ResourceBundle getBundle(UserNavigation navigation) {
            return null;
        }

        public Locale getUserLocale() {
            return Locale.ENGLISH;
        }
    };

    public LegacyRequestHandler(URLFactoryService urlFactory, UserPortalConfigService userPortalService) {
        this.urlFactory = urlFactory;
        this.userPortalService = userPortalService;
    }

    public String getHandlerName() {
        return "legacy";
    }

    public void execute(ControllerContext context) throws Exception {
        String uri;
        SiteKey siteKey;
        UserNodeFilterConfig.Builder builder;
        String requestSiteName = context.getParameter(PortalRequestHandler.REQUEST_SITE_NAME);
        String requestPath = context.getParameter(PortalRequestHandler.REQUEST_PATH);
        UserPortalConfig cfg = this.userPortalService.getUserPortalConfig(requestSiteName, context.getRequest().getRemoteUser(), this.userPortalContext);
        UserPortal userPortal = cfg.getUserPortal();
        UserNode userNode = userPortal.resolvePath((builder = UserNodeFilterConfig.builder().withAuthMode(1)).build(), requestPath);
        if (userNode != null) {
            siteKey = userNode.getNavigation().getKey();
            uri = userNode.getURI();
        } else {
            siteKey = SiteKey.portal((String)"classic");
            uri = "";
        }
        PortalURLContext urlContext = new PortalURLContext(context, siteKey);
        NodeURL url = (NodeURL)this.urlFactory.newURL(NodeURL.TYPE, (URLContext)urlContext);
        url.setResource(new NavigationResource(siteKey.getType(), siteKey.getName(), uri));
        url.setMimeType(MimeType.PLAIN);
        HttpServletRequest request = context.getRequest();
        Enumeration paraNames = request.getParameterNames();
        while (paraNames.hasMoreElements()) {
            String parameter = paraNames.nextElement().toString();
            url.setQueryParameterValues(parameter, request.getParameterValues(parameter));
        }
        String s = url.toString();
        HttpServletResponse resp = context.getResponse();
        resp.sendRedirect(resp.encodeRedirectURL(s));
    }
}

