/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.rmi.dgc.VMID;
import java.rmi.server.UID;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.bootstrap.spi.util.ServerConfigUtil;
import org.jboss.ha.framework.server.ChannelInfo;
import org.jboss.ha.framework.server.JChannelFactoryMBean;
import org.jboss.ha.framework.server.ProtocolStackConfigInfo;
import org.jboss.ha.framework.server.ProtocolStackUtil;
import org.jboss.ha.framework.server.managed.OpenChannelsMapper;
import org.jboss.ha.framework.server.managed.ProtocolStackConfigurationsMapper;
import org.jboss.logging.Logger;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.metatype.api.annotations.MetaMapping;
import org.jboss.system.ServiceMBean;
import org.jboss.util.loading.ContextClassLoaderSwitcher;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.ChannelFactory;
import org.jgroups.ChannelListener;
import org.jgroups.ChannelListenerAdapter;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolData;
import org.jgroups.conf.ProtocolParameter;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.jmx.Protocol;
import org.jgroups.protocols.TP;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.LazyThreadFactory;
import org.jgroups.util.ThreadDecorator;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.ThreadManager;
import org.jgroups.util.Util;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagementObject(name="JChannelFactory", componentType=@ManagementComponent(type="MCBean", subtype="JGroupsChannelFactory"), properties=ManagementProperties.EXPLICIT, isRuntime=true)
public class JChannelFactory
implements ChannelFactory,
JChannelFactoryMBean,
MBeanRegistration {
    protected static final Logger log = Logger.getLogger(JChannelFactory.class);
    public static final String UNSHARED_TRANSPORT_NAME_BASE = "unnamed_";
    public static final String DEFAULT_JMX_DOMAIN = "jgroups";
    private static final int CREATED = 6;
    private static final int STARTING = 2;
    private static final int STARTED = 3;
    private static final int STOPPING = 1;
    private static final int STOPPED = 0;
    private static final int DESTROYED = 5;
    private static final int FAILED = 4;
    private InetAddress nodeAddress;
    private String nodeName;
    private int namingServicePort = -1;
    private int state = 7;
    private boolean assignLogicalAddresses = true;
    private boolean manageNewThreadClassLoader = true;
    private boolean manageReleasedThreadClassLoader = false;
    private boolean addMissingSingletonName = true;
    private final ContextClassLoaderSwitcher classLoaderSwitcher;
    private final Map<Channel, ChannelInfo> registeredChannels = new ConcurrentHashMap<Channel, ChannelInfo>(16, 0.75f, 2);
    private ChannelCloseListener closeListener = new ChannelCloseListener();
    private final Map<String, ProtocolStackConfigInfo> stacks = new ConcurrentHashMap<String, ProtocolStackConfigInfo>(16, 0.75f, 2);
    private Map<String, ProtocolStackConfigInfo> injectedStacks;
    private MBeanServer server = null;
    private String domain = "jgroups";
    private boolean domainSet = false;
    private boolean expose_channels = true;
    private boolean expose_protocols = true;

    public JChannelFactory() {
        this.classLoaderSwitcher = (ContextClassLoaderSwitcher)AccessController.doPrivileged(ContextClassLoaderSwitcher.INSTANTIATOR);
    }

    public Channel createChannel() throws ChannelException {
        throw new ChannelException("No-arg createChannel() is not supported");
    }

    public Channel createChannel(Object properties) throws ChannelException {
        this.checkStarted();
        if (properties == null) {
            properties = "udp.xml";
        }
        ProtocolStackConfigurator config = null;
        try {
            ProtocolStackConfigurator c;
            config = c = ConfiguratorFactory.getStackConfigurator((Object)properties);
        }
        catch (Exception x) {
            throw new ChannelException("unable to load protocol stack", (Throwable)x);
        }
        JChannel channel = this.initializeChannel(config, null, false);
        try {
            this.registerChannel(channel, null, null, ProtocolStackUtil.getProtocolData(config));
        }
        catch (ChannelException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ChannelException("unable to register channel", (Throwable)e);
        }
        return channel;
    }

    @Override
    public Channel createChannel(String stack_name) throws Exception {
        return this.createChannelFromRegisteredStack(stack_name, null, false);
    }

    @Override
    public Channel createMultiplexerChannel(String stack_name, String id) throws Exception {
        return this.createChannelFromRegisteredStack(stack_name, id, true);
    }

    @Override
    public Channel createMultiplexerChannel(String stack_name, String id, boolean register_for_state_transfer, String substate_id) throws Exception {
        return this.createMultiplexerChannel(stack_name, id);
    }

    public void setMultiplexerConfig(Element properties) throws Exception {
        this.setMultiplexerConfig(properties, true);
    }

    public void setMultiplexerConfig(File properties) throws Exception {
        this.setMultiplexerConfig(properties, true);
    }

    public void setMultiplexerConfig(Object properties) throws Exception {
        this.setMultiplexerConfig(properties, true);
    }

    @Override
    public void setMultiplexerConfig(String properties) throws Exception {
        this.setMultiplexerConfig(properties, true);
    }

    public void setMultiplexerConfig(URL properties) throws Exception {
        this.setMultiplexerConfig(properties, true);
    }

    public MBeanServer getServer() {
        return this.server;
    }

    public void setServer(MBeanServer server) {
        this.server = server;
    }

    @Override
    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The domain portion of the JMX ObjectName to use when registering channels and protocols")
    public String getDomain() {
        return this.domain == null ? DEFAULT_JMX_DOMAIN : this.domain;
    }

    @Override
    public void setDomain(String domain) {
        this.domain = domain;
        this.domainSet = true;
    }

    @Override
    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="Whether to expose channels we create via JMX")
    public boolean isExposeChannels() {
        return this.expose_channels;
    }

    @Override
    public void setExposeChannels(boolean expose_channels) {
        this.expose_channels = expose_channels;
    }

    @Override
    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="Whether to expose protocols via JMX as well if we expose channels")
    public boolean isExposeProtocols() {
        return this.expose_protocols;
    }

    @Override
    public void setExposeProtocols(boolean expose_protocols) {
        this.expose_protocols = expose_protocols;
        if (expose_protocols) {
            this.expose_channels = true;
        }
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="The cluster-unique logical name of this node")
    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public InetAddress getNodeAddress() {
        return this.nodeAddress;
    }

    public void setNodeAddress(InetAddress nodeAddress) {
        this.nodeAddress = nodeAddress;
    }

    public int getNamingServicePort() {
        return this.namingServicePort;
    }

    public void setNamingServicePort(int jndiPort) {
        this.namingServicePort = jndiPort;
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="Whether this factory should assign a logical address for this node to all channels")
    public boolean getAssignLogicalAddresses() {
        return this.assignLogicalAddresses;
    }

    public void setAssignLogicalAddresses(boolean logicalAddresses) {
        this.assignLogicalAddresses = logicalAddresses;
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="Whether this factory should update the standard JGroups thread factories to ensure classloader leaks do not occur")
    public boolean getManageNewThreadClassLoader() {
        return this.manageNewThreadClassLoader;
    }

    public void setManageNewThreadClassLoader(boolean manage) {
        this.manageNewThreadClassLoader = manage;
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="Whether this factory should update the standard JGroups thread pools to ensure classloader leaks do not occur")
    public boolean getManageReleasedThreadClassLoader() {
        return this.manageReleasedThreadClassLoader;
    }

    public void setManageReleasedThreadClassLoader(boolean manage) {
        this.manageReleasedThreadClassLoader = manage;
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="Whether this factory should create a synthetic singleton name attribute for a channel's transport protocol if one isn't configured")
    public boolean getAddMissingSingletonName() {
        return this.addMissingSingletonName;
    }

    public void setAddMissingSingletonName(boolean addMissingSingletonName) {
        this.addMissingSingletonName = addMissingSingletonName;
    }

    public void setMultiplexerConfig(Element properties, boolean replace) throws Exception {
        Map<String, ProtocolStackConfigInfo> map = ProtocolStackUtil.parse(properties);
        for (Map.Entry<String, ProtocolStackConfigInfo> entry : map.entrySet()) {
            this.addConfig(entry.getKey(), entry.getValue(), replace);
        }
    }

    public void setMultiplexerConfig(File properties, boolean replace) throws Exception {
        InputStream input = ConfiguratorFactory.getConfigStream((File)properties);
        this.addConfigs(input, properties.toString(), replace);
    }

    public void setMultiplexerConfig(Object properties, boolean replace) throws Exception {
        InputStream input = ConfiguratorFactory.getConfigStream((Object)properties);
        this.addConfigs(input, properties.toString(), replace);
    }

    @Override
    public void setMultiplexerConfig(String properties, boolean replace) throws Exception {
        InputStream input = ConfiguratorFactory.getConfigStream((String)properties);
        this.addConfigs(input, properties, replace);
    }

    public void setMultiplexerConfig(URL url, boolean replace) throws Exception {
        InputStream input = ConfiguratorFactory.getConfigStream((URL)url);
        this.addConfigs(input, url.toString(), replace);
    }

    @ManagementProperty(use={ViewUse.STATISTIC}, description="Information on channels created by this factory that are currently open", readOnly=true)
    @MetaMapping(value=OpenChannelsMapper.class)
    public Set<ChannelInfo> getOpenChannels() {
        return new HashSet<ChannelInfo>(this.registeredChannels.values());
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION, ViewUse.RUNTIME}, description="Protocol stack configurations available for use")
    @MetaMapping(value=ProtocolStackConfigurationsMapper.class)
    public Map<String, ProtocolStackConfigInfo> getProtocolStackConfigurations() {
        return Collections.unmodifiableMap(this.stacks);
    }

    public void setProtocolStackConfigurations(Map<String, ProtocolStackConfigInfo> configs) {
        this.injectedStacks = configs;
        if (this.state == 3) {
            this.processInjectedStacks();
        }
    }

    @Override
    public void clearConfigurations() {
        this.stacks.clear();
    }

    @Override
    public String dumpChannels() {
        return "";
    }

    @Override
    public String dumpConfiguration() {
        return this.stacks.keySet().toString();
    }

    @Override
    public String getConfig(String stack_name) throws Exception {
        ProtocolStackConfigInfo cfg = this.stacks.get(stack_name);
        if (cfg == null) {
            throw new Exception("stack \"" + stack_name + "\" not found in " + this.stacks.keySet());
        }
        return cfg.getConfigurator().getProtocolStackString();
    }

    @Override
    public String getMultiplexerConfig() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, ProtocolStackConfigInfo> entry : this.stacks.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue().getConfigurator().getProtocolStackString()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public boolean removeConfig(String stack_name) {
        return stack_name != null && this.stacks.remove(stack_name) != null;
    }

    @Override
    public void create() throws Exception {
        if (this.state == 6 || this.state == 2 || this.state == 3 || this.state == 1 || this.state == 0) {
            log.debug((Object)("Ignoring create call; current state is " + this.getStateString()));
            return;
        }
        log.debug((Object)"Creating JChannelFactory");
        try {
            this.createService();
            this.state = 6;
        }
        catch (Exception e) {
            log.debug((Object)"Initialization failed JChannelFactory", (Throwable)e);
            throw e;
        }
        log.debug((Object)"Created JChannelFactory");
    }

    @Override
    public void start() throws Exception {
        if (this.state == 2 || this.state == 3 || this.state == 1) {
            log.debug((Object)("Ignoring start call; current state is " + this.getStateString()));
            return;
        }
        if (this.state != 6 && this.state != 0 && this.state != 4) {
            log.debug((Object)"Start requested before create, calling create now");
            this.create();
        }
        this.state = 2;
        log.debug((Object)"Starting JChannelFactory");
        try {
            this.startService();
        }
        catch (Exception e) {
            this.state = 4;
            log.debug((Object)"Starting failed JChannelFactory", (Throwable)e);
            throw e;
        }
        this.state = 3;
        log.debug((Object)"Started JChannelFactory");
    }

    @Override
    public void stop() {
        if (this.state != 3) {
            log.debug((Object)("Ignoring stop call; current state is " + this.getStateString()));
            return;
        }
        this.state = 1;
        log.debug((Object)"Stopping JChannelFactory");
        try {
            this.stopService();
        }
        catch (Throwable e) {
            this.state = 4;
            log.warn((Object)"Stopping failed JChannelFactory", e);
            return;
        }
        this.state = 0;
        log.debug((Object)"Stopped JChannelFactory");
    }

    @Override
    public void destroy() {
        if (this.state == 5) {
            log.debug((Object)("Ignoring destroy call; current state is " + this.getStateString()));
            return;
        }
        if (this.state == 3) {
            log.debug((Object)"Destroy requested before stop, calling stop now");
            this.stop();
        }
        log.debug((Object)"Destroying JChannelFactory");
        try {
            this.destroyService();
        }
        catch (Throwable t) {
            log.warn((Object)"Destroying failed JChannelFactory", t);
        }
        this.state = 5;
        log.debug((Object)"Destroyed JChannelFactory");
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.setServer(server);
        if (!this.domainSet || this.domain == null) {
            this.setDomain(name.getDomain());
        }
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        if (registrationDone != null && registrationDone.booleanValue() && this.state == 7) {
            this.state = 8;
        }
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
        this.setServer(null);
        if (this.state == 5) {
            this.state = 7;
        }
    }

    protected ClassLoader getDefaultChannelThreadContextClassLoader() {
        return this.getClass().getClassLoader();
    }

    protected void createService() throws Exception {
        if (this.expose_channels) {
            if (this.server == null) {
                throw new Exception("No MBeanServer found; JChannelFactory needs to be run with an MBeanServer present, or with ExposeChannels set to false");
            }
            if (this.domain == null) {
                this.domain = DEFAULT_JMX_DOMAIN;
            }
        }
    }

    protected void startService() throws Exception {
        this.processInjectedStacks();
    }

    protected void stopService() throws Exception {
    }

    protected void destroyService() {
        for (Channel ch : this.registeredChannels.keySet()) {
            this.unregisterChannel(ch);
        }
    }

    private void checkStarted() {
        if (this.state != 3) {
            throw new IllegalStateException("Cannot use factory; state is " + this.getStateString());
        }
    }

    private void addConfigs(InputStream input, String source, boolean replace) throws Exception {
        if (input == null) {
            throw new FileNotFoundException(source);
        }
        Map<String, ProtocolStackConfigInfo> map = null;
        try {
            map = ProtocolStackUtil.parse(input);
        }
        catch (Exception ex) {
            throw new Exception("failed parsing " + source, ex);
        }
        finally {
            Util.close((InputStream)input);
        }
        for (Map.Entry<String, ProtocolStackConfigInfo> entry : map.entrySet()) {
            this.addConfig(entry.getKey(), entry.getValue(), replace);
        }
    }

    private boolean addConfig(String st_name, ProtocolStackConfigInfo val, boolean replace) {
        boolean added = replace;
        if (replace) {
            this.stacks.put(st_name, val);
            if (log.isTraceEnabled()) {
                log.trace((Object)("added config '" + st_name + "'"));
            }
        } else if (!this.stacks.containsKey(st_name)) {
            this.stacks.put(st_name, val);
            if (log.isTraceEnabled()) {
                log.trace((Object)("added config '" + st_name + "'"));
            }
            added = true;
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("didn't add config '" + st_name + " because one of the same name already existed"));
        }
        return added;
    }

    private synchronized void processInjectedStacks() {
        if (this.injectedStacks != null) {
            this.clearConfigurations();
            this.stacks.putAll(this.injectedStacks);
            this.injectedStacks = null;
        }
    }

    private Channel createChannelFromRegisteredStack(String stack_name, String id, boolean forceSingletonStack) throws Exception {
        this.checkStarted();
        ProtocolStackConfigInfo config = this.stacks.get(stack_name);
        if (config == null) {
            throw new IllegalArgumentException("Unknown stack_name " + stack_name);
        }
        JChannel channel = this.initializeChannel(config.getConfigurator(), stack_name, forceSingletonStack);
        this.registerChannel(channel, id, stack_name, ProtocolStackUtil.getProtocolData(config.getConfigurator()));
        return channel;
    }

    private JChannel initializeChannel(ProtocolStackConfigurator config, String stack_name, boolean forceSingletonStack) throws ChannelException {
        Map<String, String> tpProps = this.getTransportProperties(config);
        if (!tpProps.containsKey("singleton_name")) {
            if (this.addMissingSingletonName && stack_name != null) {
                String singletonName = UNSHARED_TRANSPORT_NAME_BASE + stack_name;
                log.warn((Object)("Config for " + stack_name + " does not include " + "singleton_name; adding a name of " + singletonName + ". You should configure a singleton_name for this stack."));
                config = this.addSingletonName(config, singletonName);
                log.debug((Object)("Stack config after adding singleton_name is " + config.getProtocolStackString()));
                tpProps = this.getTransportProperties(config);
            } else if (forceSingletonStack) {
                throw new IllegalStateException("Config for " + stack_name + " does not include " + "singleton_name and MuxChannels are not supported.");
            }
        }
        JChannel channel = new JChannel(config);
        if (this.manageNewThreadClassLoader || this.manageReleasedThreadClassLoader) {
            this.fixChannelThreadManagement((Channel)channel);
        }
        if (this.assignLogicalAddresses) {
            this.setChannelUniqueId((Channel)channel);
        }
        return channel;
    }

    private String getStateString() {
        return ServiceMBean.states[this.state];
    }

    private void setChannelUniqueId(Channel channel) {
        IpAddress address = (IpAddress)channel.getLocalAddress();
        if (address == null) {
            if (this.nodeName == null || "".equals(this.nodeName)) {
                this.nodeName = this.generateUniqueNodeName();
            }
            log.debug((Object)("Passing unique node id " + this.nodeName + " to the channel as additional data"));
            HashMap<String, byte[]> staticNodeName = new HashMap<String, byte[]>();
            staticNodeName.put("additional_data", this.nodeName.getBytes());
            channel.down(new Event(56, staticNodeName));
        } else if (address.getAdditionalData() == null) {
            if (channel.isConnected()) {
                throw new IllegalStateException("Underlying JChannel was connected before additional_data was set");
            }
        } else if (this.nodeName == null || "".equals(this.nodeName)) {
            this.nodeName = new String(address.getAdditionalData());
            log.warn((Object)("Field nodeName was not set but mux channel already had additional data -- setting nodeName to " + this.nodeName));
        }
    }

    private String generateUniqueNodeName() {
        String hostIP = null;
        InetAddress address = ServerConfigUtil.fixRemoteAddress((InetAddress)this.nodeAddress);
        if (address == null) {
            log.debug((Object)"unable to create a GUID for this cluster, check network configuration is correctly setup (getLocalHost has returned an exception)");
            log.debug((Object)"using a full GUID strategy");
            return new VMID().toString();
        }
        hostIP = address.getHostAddress();
        if (this.namingServicePort > 0) {
            return hostIP + ":" + this.namingServicePort;
        }
        log.warn((Object)"JNDI has been found but the service wasn't started. Most likely, HAPartition bean is missing dependency on JBoss Naming. Instead using host based UID strategy for defining a node GUID for the cluster.");
        String uid = new UID().toString();
        return hostIP + ":" + uid;
    }

    private Map<String, String> getTransportProperties(ProtocolStackConfigurator config) {
        HashMap<String, String> tpProps = null;
        ProtocolData[] protocols = ProtocolStackUtil.getProtocolData(config);
        ProtocolData transport = protocols[0];
        HashMap tmp = transport.getParameters();
        tpProps = new HashMap<String, String>();
        for (Map.Entry entry : tmp.entrySet()) {
            tpProps.put((String)entry.getKey(), ((ProtocolParameter)entry.getValue()).getValue());
        }
        return tpProps;
    }

    private ProtocolStackConfigurator addSingletonName(ProtocolStackConfigurator orig, String singletonName) throws ChannelException {
        ProtocolStackConfigurator result = null;
        try {
            ProtocolData[] protocols = orig.getProtocolStack();
            ProtocolData transport = protocols[0];
            ProtocolParameter singletonParam = new ProtocolParameter("singleton_name", singletonName);
            transport.override(new ProtocolParameter[]{singletonParam});
            result = orig;
        }
        catch (UnsupportedOperationException uoe) {
            String config = orig.getProtocolStackString();
            int idx = config.indexOf(40) + 1;
            StringBuilder builder = new StringBuilder(config.substring(0, idx));
            builder.append("singleton_name");
            builder.append('=');
            builder.append(singletonName);
            builder.append(';');
            builder.append(config.substring(idx));
            result = ConfiguratorFactory.getStackConfigurator((String)builder.toString());
        }
        return result;
    }

    private void fixChannelThreadManagement(Channel channel) throws ChannelException {
        if (!(channel instanceof JChannel)) {
            log.debug((Object)("Cannot fix thread pools for unknown Channel type " + channel.getClass().getName()));
            return;
        }
        JChannel jchannel = (JChannel)channel;
        ProtocolStack stack = jchannel.getProtocolStack();
        Vector protocols = stack.getProtocols();
        TP tp = null;
        for (int i = protocols.size() - 1; i >= 0; --i) {
            if (!(protocols.get(i) instanceof TP)) continue;
            tp = (TP)protocols.get(i);
            break;
        }
        ClassLoader defaultTCCL = this.getDefaultChannelThreadContextClassLoader();
        ThreadDecoratorImpl threadDecorator = new ThreadDecoratorImpl(defaultTCCL);
        if (this.manageNewThreadClassLoader) {
            this.fixProtocolThreadFactories(tp, threadDecorator);
        }
        if (this.manageReleasedThreadClassLoader) {
            this.fixTransportThreadPools(tp, threadDecorator);
        }
    }

    private void fixProtocolThreadFactories(TP tp, ThreadDecoratorImpl threadDecorator) {
        ThreadFactory stackFactory = tp.getThreadFactory();
        if (stackFactory == null) {
            stackFactory = new DefaultThreadFactory(Util.getGlobalThreadGroup(), "", false);
            tp.setThreadFactory(stackFactory);
        }
        this.fixThreadManager(stackFactory, threadDecorator, "TP.getThreadFactory()");
        log.debug((Object)("Fixed thread factory for " + tp));
        ThreadFactory timerFactory = tp.getTimerThreadFactory();
        if (timerFactory == null) {
            timerFactory = new LazyThreadFactory(Util.getGlobalThreadGroup(), "Timer", true, true);
            tp.setTimerThreadFactory(timerFactory);
        }
        this.fixThreadManager(timerFactory, threadDecorator, "TP.getTimerThreadFactory()");
        log.debug((Object)("Fixed timer thread factory for " + tp));
        ThreadGroup pool_thread_group = null;
        if (tp.isDefaulThreadPoolEnabled()) {
            ThreadFactory defaultPoolFactory = tp.getDefaultThreadPoolThreadFactory();
            if (defaultPoolFactory == null) {
                pool_thread_group = new ThreadGroup(Util.getGlobalThreadGroup(), "Thread Pools");
                defaultPoolFactory = new DefaultThreadFactory(pool_thread_group, "Incoming", false, true);
                tp.setThreadFactory(defaultPoolFactory);
            }
            this.fixThreadManager(defaultPoolFactory, threadDecorator, "TP.getDefaultThreadPoolThreadFactory()");
            log.debug((Object)("Fixed default pool thread factory for " + tp));
        }
        if (tp.isOOBThreadPoolEnabled()) {
            ThreadFactory oobPoolFactory = tp.getOOBThreadPoolThreadFactory();
            if (oobPoolFactory == null) {
                if (pool_thread_group == null) {
                    pool_thread_group = new ThreadGroup(Util.getGlobalThreadGroup(), "Thread Pools");
                }
                oobPoolFactory = new DefaultThreadFactory(pool_thread_group, "OOB", false, true);
                tp.setThreadFactory(oobPoolFactory);
            }
            this.fixThreadManager(oobPoolFactory, threadDecorator, "TP.getOOBThreadPoolThreadFactory()");
            log.debug((Object)("Fixed oob pool thread factory for " + tp));
        }
        HashMap<ThreadFactory, org.jgroups.stack.Protocol> factories = new HashMap<ThreadFactory, org.jgroups.stack.Protocol>();
        for (org.jgroups.stack.Protocol tmp = tp.getUpProtocol(); tmp != null; tmp = tmp.getUpProtocol()) {
            ThreadFactory f = tmp.getThreadFactory();
            if (f == null || factories.containsKey(f)) continue;
            factories.put(f, tmp);
        }
        for (Map.Entry entry : factories.entrySet()) {
            this.fixThreadManager(entry.getKey(), threadDecorator, ((org.jgroups.stack.Protocol)entry.getValue()).getClass().getSimpleName() + ".getThreadFactory()");
        }
        log.debug((Object)"Fixed Protocol thread factories");
    }

    private void fixTransportThreadPools(TP tp, ThreadDecoratorImpl threadDecorator) {
        Executor threadPool = tp.getDefaultThreadPool();
        if (tp.isDefaulThreadPoolEnabled()) {
            this.fixThreadManager(threadPool, threadDecorator, "TP.getDefaultThreadPool()");
            log.debug((Object)("Fixed default thread pool for " + tp));
        }
        threadPool = tp.getOOBThreadPool();
        if (tp.isOOBThreadPoolEnabled()) {
            this.fixThreadManager(threadPool, threadDecorator, "TP.getOOBThreadPool()");
            log.debug((Object)("Fixed OOB thread pool for " + tp));
        }
    }

    private void fixThreadManager(Object manager, ThreadDecoratorImpl decorator, String managerSource) {
        if (manager instanceof ThreadManager) {
            ThreadManager threadManager = (ThreadManager)manager;
            ThreadDecorator existing = threadManager.getThreadDecorator();
            if (existing instanceof ThreadDecoratorImpl) {
                return;
            }
            if (existing != null) {
                decorator.setParent(existing);
            }
            threadManager.setThreadDecorator((ThreadDecorator)decorator);
        } else {
            log.warn((Object)(managerSource + " is not a ThreadManager"));
        }
    }

    private void setDefaultThreadContextClassLoader(Thread thread, ClassLoader classLoader) {
        this.classLoaderSwitcher.setContextClassLoader(thread, classLoader);
    }

    private void registerChannel(JChannel ch, String channelId, String stackName, ProtocolData[] config) throws Exception {
        ch.addChannelListener((ChannelListener)this.closeListener);
        ObjectName chName = null;
        List<ObjectName> protNames = null;
        List<ObjectName> allNames = this.registerInJmx(ch, channelId);
        if (allNames != null && allNames.size() > 0) {
            chName = allNames.get(0);
            if (allNames.size() > 1) {
                protNames = allNames.subList(1, allNames.size());
            }
        }
        ChannelInfo info = new ChannelInfo(channelId, stackName, (Channel)ch, config, chName, protNames);
        this.registeredChannels.put((Channel)ch, info);
    }

    private List<ObjectName> registerInJmx(JChannel ch, String channelId) throws Exception {
        ArrayList<Object> allNames = null;
        if (this.isExposeChannels() && this.getServer() != null && channelId != null && channelId.length() > 0) {
            allNames = new ArrayList<Object>();
            ObjectName channelName = new ObjectName(this.getDomain() + ":type=channel,cluster=" + channelId);
            this.getServer().registerMBean(new org.jgroups.jmx.JChannel(ch), channelName);
            allNames.add(channelName);
            if (this.isExposeProtocols()) {
                String baseName = this.getDomain() + ":type=protocol,cluster=" + channelId;
                ProtocolStack stack = ch.getProtocolStack();
                Vector protocols = stack.getProtocols();
                for (org.jgroups.stack.Protocol prot : protocols) {
                    Object prot_name;
                    Protocol p = null;
                    try {
                        prot_name = prot.getClass().getName();
                        String clname = ((String)prot_name).replaceFirst("org.jgroups.", "org.jgroups.jmx.");
                        Class cl = Util.loadClass((String)clname, JmxConfigurator.class);
                        if (cl != null) {
                            p = (Protocol)cl.newInstance();
                        }
                    }
                    catch (ClassNotFoundException e) {
                    }
                    catch (Throwable e) {
                        log.error((Object)("failed creating a JMX wrapper instance for " + prot), e);
                        p = null;
                    }
                    if (p == null) {
                        p = new Protocol(prot);
                    } else {
                        p.attachProtocol(prot);
                    }
                    prot_name = new ObjectName(baseName + ",protocol=" + prot.getName());
                    this.server.registerMBean(p, (ObjectName)prot_name);
                    allNames.add(prot_name);
                }
            }
        }
        return allNames;
    }

    private void unregisterChannel(Channel ch) {
        ChannelInfo info = this.registeredChannels.remove(ch);
        if (info == null) {
            log.warn((Object)("Unknown channel " + ch.getClusterName()));
        } else {
            this.unregisterFromJmx(info);
        }
        ch.removeChannelListener((ChannelListener)this.closeListener);
    }

    private void unregisterFromJmx(ChannelInfo info) {
        ObjectName oname = info.getChannelObjectName();
        MBeanServer mbs = this.getServer();
        if (info != null && mbs != null) {
            try {
                mbs.unregisterMBean(oname);
            }
            catch (Exception e) {
                log.error((Object)("failed unregistering " + oname), (Throwable)e);
            }
            List<ObjectName> onames = info.getProtocolObjectNames();
            if (onames != null) {
                for (ObjectName protName : onames) {
                    try {
                        mbs.unregisterMBean(protName);
                    }
                    catch (Exception e) {
                        log.error((Object)("failed unregistering " + protName), (Throwable)e);
                    }
                }
            }
        }
    }

    private class ChannelCloseListener
    extends ChannelListenerAdapter {
        private ChannelCloseListener() {
        }

        public void channelClosed(Channel channel) {
            JChannelFactory.this.unregisterChannel(channel);
        }
    }

    private class ThreadDecoratorImpl
    implements ThreadDecorator {
        private final ClassLoader classloader;
        private ThreadDecorator parent;

        private ThreadDecoratorImpl(ClassLoader classloader) {
            this.classloader = classloader;
        }

        public void threadCreated(Thread thread) {
            if (this.parent != null) {
                this.parent.threadCreated(thread);
            }
            JChannelFactory.this.setDefaultThreadContextClassLoader(thread, this.classloader);
        }

        public void threadReleased(Thread thread) {
            if (this.parent != null) {
                this.parent.threadCreated(thread);
            }
            JChannelFactory.this.setDefaultThreadContextClassLoader(thread, this.classloader);
        }

        public ThreadDecorator getParent() {
            return this.parent;
        }

        public void setParent(ThreadDecorator parent) {
            this.parent = parent;
        }
    }
}

