/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.json;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMSource;
import org.codehaus.jettison.badgerfish.BadgerFishXMLOutputFactory;
import org.jboss.ws.extensions.json.BadgerFishXMLEventWriter;
import org.w3c.dom.Element;

public class BadgerFishDOMDocumentSerializer {
    private OutputStream output;

    public BadgerFishDOMDocumentSerializer(OutputStream output) {
        this.output = output;
    }

    public void serialize(Element el) throws IOException {
        if (this.output == null) {
            throw new IllegalStateException("OutputStream cannot be null");
        }
        try {
            DOMSource source = new DOMSource(el);
            XMLInputFactory readerFactory = XMLInputFactory.newInstance();
            XMLStreamReader streamReader = readerFactory.createXMLStreamReader(source);
            XMLEventReader eventReader = readerFactory.createXMLEventReader(streamReader);
            BadgerFishXMLOutputFactory writerFactory = new BadgerFishXMLOutputFactory();
            XMLStreamWriter streamWriter = writerFactory.createXMLStreamWriter(this.output);
            BadgerFishXMLEventWriter eventWriter = new BadgerFishXMLEventWriter(streamWriter);
            eventWriter.add(eventReader);
            eventWriter.close();
        }
        catch (XMLStreamException ex) {
            IOException ioex = new IOException("Cannot serialize: " + el);
            ioex.initCause(ex);
            throw ioex;
        }
    }
}

