/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logbridge;

import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.jboss.logbridge.SourceLevelKey;
import org.jboss.logbridge.TargetLevel;
import org.jboss.logbridge.TargetLevelKey;
import org.jboss.logging.log4j.JDKLevel;
import org.jboss.logmanager.Level;

public final class LevelMapper {
    private final SortedMap<TargetLevelKey, SourceLevelKey> targetToSource = new TreeMap<TargetLevelKey, SourceLevelKey>();
    private final SortedMap<SourceLevelKey, TargetLevelKey> sourceToTarget = new TreeMap<SourceLevelKey, TargetLevelKey>();
    private final Logger log = Logger.getLogger(LevelMapper.class);

    public LevelMapper() {
        this.registerMapping(JDKLevel.SEVERE, new SourceLevelKey(java.util.logging.Level.SEVERE));
        this.registerMapping(JDKLevel.WARNING, new SourceLevelKey(java.util.logging.Level.WARNING));
        this.registerMapping(JDKLevel.INFO, new SourceLevelKey(java.util.logging.Level.INFO));
        this.registerMapping(JDKLevel.CONFIG, new SourceLevelKey(java.util.logging.Level.CONFIG));
        this.registerMapping(JDKLevel.FINE, new SourceLevelKey(java.util.logging.Level.FINE));
        this.registerMapping(JDKLevel.FINER, new SourceLevelKey(java.util.logging.Level.FINER));
        this.registerMapping(JDKLevel.FINEST, new SourceLevelKey(java.util.logging.Level.FINEST));
        this.registerMapping(org.apache.log4j.Level.FATAL, new SourceLevelKey((java.util.logging.Level)Level.FATAL));
        this.registerMapping(org.apache.log4j.Level.ERROR, new SourceLevelKey((java.util.logging.Level)Level.ERROR));
        this.registerMapping(org.apache.log4j.Level.WARN, new SourceLevelKey((java.util.logging.Level)Level.WARN));
        this.registerMapping(org.apache.log4j.Level.DEBUG, new SourceLevelKey((java.util.logging.Level)Level.DEBUG));
        this.registerMapping(org.apache.log4j.Level.TRACE, new SourceLevelKey((java.util.logging.Level)Level.TRACE));
    }

    public synchronized org.apache.log4j.Level registerMapping(int targetLevelValue, int targetSyslogLevel, SourceLevelKey sourceKey) {
        String name = sourceKey.getLevel().getName();
        TargetLevel targetLevel = new TargetLevel(targetLevelValue, name, targetSyslogLevel);
        return this.registerMapping(targetLevel, sourceKey);
    }

    public synchronized org.apache.log4j.Level registerMapping(org.apache.log4j.Level targetLevel, SourceLevelKey sourceKey) {
        String name = targetLevel.toString();
        TargetLevelKey targetKey = new TargetLevelKey(targetLevel);
        if (this.targetToSource.containsKey(targetKey) || this.sourceToTarget.containsKey(sourceKey)) {
            throw new IllegalArgumentException("Cannot register log level '" + name + "' (already exists)");
        }
        this.targetToSource.put(targetKey, sourceKey);
        this.sourceToTarget.put(sourceKey, targetKey);
        this.log.debug((Object)("Registered new log level '" + name + "' with value " + targetLevel.toInt()));
        return targetLevel;
    }

    public synchronized java.util.logging.Level getSourceLevelForTargetLevel(org.apache.log4j.Level targetLevel) {
        java.util.logging.Level level;
        TargetLevelKey targetKey = new TargetLevelKey(targetLevel);
        if (this.targetToSource.containsKey(targetKey) && (level = ((SourceLevelKey)this.targetToSource.get(targetKey)).getLevel()) != null) {
            return level;
        }
        return Level.INFO;
    }

    public synchronized org.apache.log4j.Level getTargetLevelForSourceLevel(java.util.logging.Level sourceLevel) {
        org.apache.log4j.Level targetLevel;
        SourceLevelKey sourceKey = new SourceLevelKey(sourceLevel);
        if (this.sourceToTarget.containsKey(sourceKey) && (targetLevel = ((TargetLevelKey)this.sourceToTarget.get(sourceKey)).getLevel()) != null) {
            return targetLevel;
        }
        SortedMap<SourceLevelKey, TargetLevelKey> headMap = this.sourceToTarget.headMap(sourceKey);
        SortedMap<SourceLevelKey, TargetLevelKey> tailMap = this.sourceToTarget.tailMap(sourceKey);
        if (headMap.isEmpty()) {
            SourceLevelKey firstKey = this.sourceToTarget.firstKey();
            TargetLevelKey firstValue = (TargetLevelKey)this.sourceToTarget.get(firstKey);
            org.apache.log4j.Level firstLevel = firstValue.getLevel();
            return this.registerMapping(firstLevel.toInt() + 10000, firstLevel.getSyslogEquivalent(), sourceKey);
        }
        if (tailMap.isEmpty()) {
            SourceLevelKey lastKey = this.sourceToTarget.lastKey();
            TargetLevelKey lastValue = (TargetLevelKey)this.sourceToTarget.get(lastKey);
            org.apache.log4j.Level lastLevel = lastValue.getLevel();
            return this.registerMapping(lastLevel.toInt() / 2, lastLevel.getSyslogEquivalent(), sourceKey);
        }
        SourceLevelKey headKey = headMap.lastKey();
        SourceLevelKey tailKey = tailMap.firstKey();
        TargetLevelKey headValue = (TargetLevelKey)headMap.get(headKey);
        TargetLevelKey tailValue = (TargetLevelKey)tailMap.get(tailKey);
        org.apache.log4j.Level headLevel = headValue.getLevel();
        org.apache.log4j.Level tailLevel = tailValue.getLevel();
        return this.registerMapping((headLevel.toInt() + tailLevel.toInt()) / 2, (headLevel.getSyslogEquivalent() + tailLevel.getSyslogEquivalent()) / 2, sourceKey);
    }
}

