/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.statistic.pool;

import java.io.StringWriter;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.resource.statistic.JBossStatistics;
import org.jboss.resource.statistic.formatter.StatisticsFormatter;
import org.jboss.resource.statistic.formatter.StatisticsFormatterException;
import org.jboss.resource.statistic.pool.JBossSubPoolStatistics;
import org.jboss.resource.statistic.pool.ManagedConnectionPoolStatistics;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class JBossXmlSubPoolStatisticFormatter
implements StatisticsFormatter {
    public Object formatSubPoolStatistics(Collection subPoolStatistics) {
        Document doc = this.createDocument();
        Element root = doc.createElement("subpool-statistics");
        doc.appendChild(root);
        for (JBossSubPoolStatistics stat : subPoolStatistics) {
            this.createChildNode(doc, root, stat);
        }
        return this.getDocumentAsString(doc);
    }

    public Object formatSubPoolStatistics(ManagedConnectionPoolStatistics stats) {
        return this.formatSubPoolStatistics(stats.getSubPools());
    }

    private void createChildNode(Document doc, Element root, JBossSubPoolStatistics stat) {
        root.appendChild(this.createTextNode(doc, "max-connections-in-use", String.valueOf(stat.getMaxConnectionsInUse())));
        root.appendChild(this.createTextNode(doc, "connections-in-use", String.valueOf(stat.getConnectionsInUse())));
        root.appendChild(this.createTextNode(doc, "connections-destroyed", String.valueOf(stat.getConnectionsDestroyed())));
        root.appendChild(this.createTextNode(doc, "available-connections", String.valueOf(stat.getAvailableConnections())));
    }

    private Element createTextNode(Document doc, String name, String value) {
        Text node = doc.createTextNode(name);
        node.setNodeValue(String.valueOf(value));
        Element child = doc.createElement(name);
        child.appendChild(node);
        return child;
    }

    private Document createDocument() {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            return doc;
        }
        catch (ParserConfigurationException e) {
            throw new StatisticsFormatterException(e.getMessage());
        }
    }

    private String getDocumentAsString(Document doc) {
        try {
            DOMSource source = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory.newInstance().newTransformer().transform(source, result);
            return writer.toString();
        }
        catch (TransformerException e) {
            throw new StatisticsFormatterException(e.getMessage());
        }
    }

    @Override
    public Object formatStatistics(JBossStatistics stats) {
        if (!(stats instanceof ManagedConnectionPoolStatistics)) {
            throw new IllegalArgumentException("Error: invalid statistics implementaiton for formatter.");
        }
        ManagedConnectionPoolStatistics poolStats = (ManagedConnectionPoolStatistics)stats;
        return this.formatSubPoolStatistics(poolStats);
    }
}

