/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security.jaspi.modules;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.StringManager;
import org.apache.coyote.ActionCode;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.security.jaspi.modules.TomcatServerAuthModule;

public class HTTPClientCertServerAuthModule
extends TomcatServerAuthModule {
    private static Logger log = Logger.getLogger(HTTPClientCertServerAuthModule.class);
    protected Context context;
    protected boolean cache = false;
    private String delgatingLoginContextName;
    public static final String CERTIFICATES_ATTR = "javax.servlet.request.X509Certificate";
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.authenticator");

    public HTTPClientCertServerAuthModule() {
    }

    public HTTPClientCertServerAuthModule(String delgatingLoginContextName) {
        this.delgatingLoginContextName = delgatingLoginContextName;
    }

    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        throw new RuntimeException("Not Applicable");
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        Request request = (Request)messageInfo.getRequestMessage();
        Response response = (Response)messageInfo.getResponseMessage();
        this.context = request.getContext();
        X509Certificate[] certs = (X509Certificate[])request.getAttribute(CERTIFICATES_ATTR);
        if (certs == null || certs.length < 1) {
            request.getCoyoteRequest().action(ActionCode.ACTION_REQ_SSL_CERTIFICATE, null);
            certs = (X509Certificate[])request.getAttribute(CERTIFICATES_ATTR);
        }
        if (certs == null || certs.length < 1) {
            log.debug((Object)"  No certificates included with this request");
            try {
                response.sendError(401, sm.getString("authenticator.certificates"));
            }
            catch (IOException e) {
                log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return AuthStatus.FAILURE;
        }
        Principal principal = this.context.getRealm().authenticate(certs);
        if (principal == null) {
            log.debug((Object)"  Realm.authenticate() returned false");
            try {
                response.sendError(401, sm.getString("authenticator.unauthorized"));
            }
            catch (IOException e) {
                log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return AuthStatus.FAILURE;
        }
        this.registerWithCallbackHandler(principal, principal.getName(), null);
        return AuthStatus.SUCCESS;
    }
}

