/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.dependency.plugins.AbstractDependencyInfo;
import org.jboss.dependency.plugins.AbstractScopeInfo;
import org.jboss.dependency.plugins.JMXObjectNameFix;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerContextActions;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.ErrorHandlingMode;
import org.jboss.dependency.spi.ScopeInfo;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractControllerContext
extends JBossObject
implements ControllerContext {
    private Object name;
    private Set<Object> aliases;
    private Object target;
    private Controller controller;
    private ControllerState state = ControllerState.ERROR;
    private ControllerState requiredState = ControllerState.NOT_INSTALLED;
    private ControllerMode mode = ControllerMode.AUTOMATIC;
    private ErrorHandlingMode errorHandlingMode = ErrorHandlingMode.DISCARD;
    private ControllerContextActions actions;
    private DependencyInfo dependencies;
    private ScopeInfo scopeInfo;
    private Throwable error;

    public AbstractControllerContext(Object name, ControllerContextActions actions) {
        this(name, null, actions, null, null);
    }

    public AbstractControllerContext(Object name, ControllerContextActions actions, DependencyInfo dependencies) {
        this(name, null, actions, dependencies, null);
    }

    public AbstractControllerContext(Object name, ControllerContextActions actions, DependencyInfo dependencies, Object target) {
        this(name, null, actions, dependencies, target);
    }

    public AbstractControllerContext(Object name, Set<Object> aliases, ControllerContextActions actions, DependencyInfo dependencies, Object target) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (actions == null) {
            throw new IllegalArgumentException("Null actions");
        }
        this.name = name;
        this.actions = actions;
        this.dependencies = dependencies == null ? new AbstractDependencyInfo() : dependencies;
        this.target = target;
        this.setAliases(aliases);
        this.initScopeInfo();
    }

    public AbstractControllerContext(Object name, Object target) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.name = name;
        this.target = target;
        this.initScopeInfo();
    }

    @Override
    public Object getName() {
        return this.name;
    }

    public void setName(Object name) {
        this.name = name;
    }

    @Override
    public Set<Object> getAliases() {
        return this.aliases;
    }

    public void setAliases(Set<Object> aliases) {
        if (aliases == null) {
            Object alias = this.needsAnAlias(this.name);
            this.aliases = alias == null ? null : Collections.singleton(alias);
        } else {
            this.aliases = new HashSet<Object>();
            Object alias = this.needsAnAlias(this.name);
            if (alias != null) {
                this.aliases.add(alias);
            }
            for (Object passedAlias : aliases) {
                this.aliases.add(passedAlias);
                alias = this.needsAnAlias(passedAlias);
                if (alias == null) continue;
                this.aliases.add(alias);
            }
        }
    }

    @Override
    public ControllerState getState() {
        return this.state;
    }

    @Override
    public ControllerState getRequiredState() {
        return this.requiredState;
    }

    @Override
    public void setRequiredState(ControllerState state) {
        this.requiredState = state;
    }

    @Override
    public ControllerMode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(ControllerMode mode) {
        if (ControllerMode.ASYNCHRONOUS.equals((Object)mode)) {
            throw new IllegalArgumentException("Not yet implemented, asynchronouse mode.");
        }
        this.mode = mode;
        this.flushJBossObjectCache();
    }

    @Override
    public ErrorHandlingMode getErrorHandlingMode() {
        return this.errorHandlingMode;
    }

    public void setErrorHandlingMode(ErrorHandlingMode errorHandlingMode) {
        if (errorHandlingMode != null && !ErrorHandlingMode.DISCARD.equals((Object)errorHandlingMode)) {
            throw new IllegalArgumentException("Not yet implemented, manual or checked error handling mode.");
        }
        this.errorHandlingMode = errorHandlingMode;
        this.flushJBossObjectCache();
    }

    @Override
    public Controller getController() {
        return this.controller;
    }

    @Override
    public void setController(Controller controller) {
        this.controller = controller;
        this.flushJBossObjectCache();
    }

    @Override
    public DependencyInfo getDependencyInfo() {
        return this.dependencies;
    }

    @Override
    public ScopeInfo getScopeInfo() {
        return this.scopeInfo;
    }

    public void setScopeInfo(ScopeInfo scopeInfo) {
        if (scopeInfo == null) {
            throw new IllegalArgumentException("Null scope info");
        }
        this.scopeInfo = scopeInfo;
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
        this.flushJBossObjectCache();
    }

    @Override
    public Throwable getError() {
        return this.error;
    }

    @Override
    public void setError(Throwable error) {
        this.error = error;
        this.state = ControllerState.ERROR;
        this.flushJBossObjectCache();
    }

    @Override
    public void setState(ControllerState state) {
        this.state = state;
        this.flushJBossObjectCache();
    }

    @Override
    public void install(ControllerState fromState, ControllerState toState) throws Throwable {
        this.error = null;
        this.flushJBossObjectCache();
        this.actions.install(this, fromState, toState);
    }

    @Override
    public void uninstall(ControllerState fromState, ControllerState toState) {
        this.flushJBossObjectCache();
        this.actions.uninstall(this, fromState, toState);
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.name);
        if (this.aliases != null) {
            buffer.append(" aliases=").append(this.aliases);
        }
        buffer.append(" target=").append(this.target);
        if (this.error != null || !this.state.equals(ControllerState.ERROR)) {
            buffer.append(" state=").append(this.state.getStateString());
        }
        if (!ControllerMode.AUTOMATIC.equals((Object)this.mode)) {
            buffer.append(" mode=").append(this.mode.getModeString());
            buffer.append(" requiredState=").append(this.requiredState.getStateString());
        }
        if (!ErrorHandlingMode.DISCARD.equals((Object)this.errorHandlingMode)) {
            buffer.append(" error-handling=").append((Object)this.errorHandlingMode);
        }
        if (this.dependencies != null) {
            buffer.append(" depends=").append((Object)this.dependencies);
        }
        if (this.error != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(stringWriter);
            this.error.printStackTrace(writer);
            writer.flush();
            buffer.append(" error=").append(stringWriter.getBuffer());
        }
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.name);
        if (this.aliases != null) {
            buffer.append(" aliases=").append(this.aliases);
        }
        if (this.error != null || !this.state.equals(ControllerState.ERROR)) {
            buffer.append(" state=").append(this.state.getStateString());
        }
        if (!ControllerMode.AUTOMATIC.equals((Object)this.mode)) {
            buffer.append(" mode=").append(this.mode.getModeString());
            buffer.append(" requiredState=").append(this.requiredState.getStateString());
        }
        if (!ErrorHandlingMode.DISCARD.equals((Object)this.errorHandlingMode)) {
            buffer.append(" error-handling=").append((Object)this.errorHandlingMode);
        }
        if (this.error != null) {
            buffer.append(" error=").append(this.error.getClass().getName()).append(": ").append(this.error.getMessage());
        }
    }

    protected void initScopeInfo() {
        String className = null;
        Object target = this.getTarget();
        if (target != null) {
            className = target.getClass().getName();
        }
        this.setScopeInfo(new AbstractScopeInfo(this.getName(), className));
    }

    protected Object needsAnAlias(Object original) {
        return JMXObjectNameFix.needsAnAlias(original);
    }
}

