/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl.clusterconnection;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.transaction.TransactionManager;
import org.jboss.jms.client.JBossSession;
import org.jboss.jms.client.container.ClientConsumer;
import org.jboss.jms.client.delegate.ClientConsumerDelegate;
import org.jboss.jms.client.state.ConsumerState;
import org.jboss.jms.delegate.ProducerDelegate;
import org.jboss.jms.delegate.SessionDelegate;
import org.jboss.jms.destination.JBossQueue;
import org.jboss.jms.message.JBossMessage;
import org.jboss.jms.message.MessageProxy;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.Queue;

public class MessageSucker
implements MessageListener {
    private static final Logger log = Logger.getLogger(MessageSucker.class);
    private boolean trace = log.isTraceEnabled();
    private Queue localQueue;
    private Session sourceSession;
    private Session localSession;
    private ProducerDelegate producer;
    private volatile boolean started;
    private TransactionManager tm;
    private boolean consuming;
    private ClientConsumerDelegate consumer;
    private ClientConsumer clientConsumer;
    private boolean preserveOrdering;
    private long sourceChannelID;
    protected JBossQueue jbq;
    private boolean suspended = false;

    public String toString() {
        return "MessageSucker:" + System.identityHashCode(this) + " queue:" + this.localQueue.getName();
    }

    protected MessageSucker(Queue localQueue, Session sourceSession, Session localSession, boolean preserveOrdering, long sourceChannelID) {
        if (this.trace) {
            log.trace((Object)("Creating message sucker, localQueue:" + localQueue + " preserveOrdering:" + preserveOrdering));
        }
        this.jbq = new JBossQueue(localQueue.getName(), true);
        this.localQueue = localQueue;
        this.sourceSession = sourceSession;
        this.localSession = localSession;
        this.preserveOrdering = preserveOrdering;
        this.sourceChannelID = sourceChannelID;
    }

    protected synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        if (this.trace) {
            log.trace((Object)(this + " starting"));
        }
        SessionDelegate localdel = ((JBossSession)this.localSession).getDelegate();
        this.producer = localdel.createProducerDelegate(this.jbq);
        SessionDelegate sourcedel = ((JBossSession)this.sourceSession).getDelegate();
        this.consumer = (ClientConsumerDelegate)sourcedel.createConsumerDelegate(this.jbq, null, false, null, false, false);
        this.clientConsumer = ((ConsumerState)this.consumer.getState()).getClientConsumer();
        this.consumer.setMessageListener(this);
        this.started = true;
        if (this.trace) {
            log.trace((Object)(this + " Registering sucker"));
        }
        this.localQueue.registerSucker(this);
        if (this.trace) {
            log.trace((Object)(this + " Registered sucker"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop() {
        this.localQueue.unregisterSucker(this);
        MessageSucker messageSucker = this;
        synchronized (messageSucker) {
            if (!this.started) {
                return;
            }
            this.setConsuming(false);
            try {
                this.consumer.closing(-1L);
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                this.consumer.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                this.producer.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.sourceSession = null;
            this.localSession = null;
            this.consumer = null;
            this.clientConsumer = null;
            this.producer = null;
            this.started = false;
        }
    }

    public synchronized void suspend() {
        if (!this.started || this.suspended) {
            return;
        }
        boolean oldConsuming = this.consuming;
        this.setConsuming(false);
        this.consuming = oldConsuming;
        this.suspended = true;
        this.sourceSession = null;
        this.consumer = null;
        this.clientConsumer = null;
        if (this.trace) {
            log.trace((Object)(this + " suspended"));
        }
    }

    public synchronized void resume(Session srcSession) throws JMSException {
        if (!this.suspended) {
            return;
        }
        this.sourceSession = srcSession;
        SessionDelegate sourcedel = ((JBossSession)this.sourceSession).getDelegate();
        this.consumer = (ClientConsumerDelegate)sourcedel.createConsumerDelegate(this.jbq, null, false, null, false, false);
        this.clientConsumer = ((ConsumerState)this.consumer.getState()).getClientConsumer();
        try {
            if (this.consuming) {
                if (this.trace) {
                    log.trace((Object)(this + " resuming client consumer"));
                }
                this.clientConsumer.resume();
            } else {
                if (this.trace) {
                    log.trace((Object)(this + " pausing client consumer"));
                }
                this.clientConsumer.pause();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.consumer.setMessageListener(this);
        this.suspended = false;
    }

    public String getQueueName() {
        return this.localQueue.getName();
    }

    public synchronized void setConsuming(boolean consume) {
        if (this.trace) {
            log.trace((Object)(this + " setConsuming " + consume));
        }
        if (!this.started) {
            return;
        }
        if (this.suspended) {
            this.consuming = consume;
            return;
        }
        try {
            if (consume && !this.consuming) {
                if (this.trace) {
                    log.trace((Object)(this + " resuming client consumer"));
                }
                this.clientConsumer.resume();
                this.consuming = true;
            } else if (!consume && this.consuming) {
                if (this.trace) {
                    log.trace((Object)(this + " pausing client consumer"));
                }
                this.clientConsumer.pause();
                this.consuming = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        try {
            if (this.trace) {
                log.trace((Object)(this + " sucked message " + msg + " JMSDestination - " + msg.getJMSDestination()));
            }
            Destination originalDestination = msg.getJMSDestination();
            JBossMessage coreMessage = ((MessageProxy)msg).getMessage();
            if (this.preserveOrdering) {
                coreMessage.putHeader("SUCKED", "x");
            }
            coreMessage.putHeader("SCID", this.sourceChannelID);
            long timeToLive = msg.getJMSExpiration();
            if (timeToLive != 0L && (timeToLive -= System.currentTimeMillis()) <= 0L) {
                timeToLive = 1L;
            }
            msg.acknowledge();
            if (this.trace) {
                log.trace((Object)"Acknowledged message");
            }
            coreMessage.getHeaders().put("JBM_ORIG_DESTINATION_SUCKER", originalDestination);
            Session session = this.localSession;
            synchronized (session) {
                this.producer.send(null, msg, msg.getJMSDeliveryMode(), msg.getJMSPriority(), timeToLive, true);
                if (this.trace) {
                    log.trace((Object)(this + " forwarded message to queue"));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to forward message", (Throwable)e);
        }
    }
}

