/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.plugins.values.defaults;

import java.io.Serializable;
import java.util.Date;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.SimpleValueSupport;

public class SimpleDefaultValueBuilder {
    public MetaValue buildMetaValue(MetaType metaType, String value) {
        SimpleValue mvalue = null;
        if (metaType.equals(SimpleMetaType.BOOLEAN)) {
            Boolean jvalue = Boolean.valueOf(value);
            mvalue = SimpleValueSupport.wrap(jvalue);
        } else if (metaType.equals(SimpleMetaType.BOOLEAN_PRIMITIVE)) {
            Boolean jvalue = Boolean.valueOf(value);
            boolean primitive = jvalue;
            mvalue = SimpleValueSupport.wrap(primitive);
        } else if (metaType.equals(SimpleMetaType.BYTE)) {
            Byte jvalue = Byte.valueOf(value);
            mvalue = SimpleValueSupport.wrap(jvalue);
        } else if (metaType.equals(SimpleMetaType.BYTE_PRIMITIVE)) {
            Byte jvalue = Byte.valueOf(value);
            byte primitive = jvalue;
            mvalue = SimpleValueSupport.wrap(primitive);
        } else if (metaType.equals(SimpleMetaType.CHARACTER)) {
            Character jvalue = Character.valueOf(value.charAt(0));
            mvalue = SimpleValueSupport.wrap(jvalue);
        } else if (metaType.equals(SimpleMetaType.CHARACTER_PRIMITIVE)) {
            mvalue = SimpleValueSupport.wrap(value.charAt(0));
        } else if (metaType.equals(SimpleMetaType.DATE)) {
            Date jvalue = new Date(value);
            mvalue = SimpleValueSupport.wrap(jvalue);
        } else if (metaType.equals(SimpleMetaType.DOUBLE)) {
            Double jvalue = Double.valueOf(value);
            mvalue = SimpleValueSupport.wrap(jvalue);
        } else if (metaType.equals(SimpleMetaType.DOUBLE_PRIMITIVE)) {
            Double jvalue = Double.valueOf(value);
            double primitive = jvalue;
            mvalue = SimpleValueSupport.wrap(primitive);
        } else if (metaType.equals(SimpleMetaType.FLOAT)) {
            Float jvalue = Float.valueOf(value);
            mvalue = SimpleValueSupport.wrap(jvalue);
        } else if (metaType.equals(SimpleMetaType.FLOAT_PRIMITIVE)) {
            Float jvalue = Float.valueOf(value);
            float primitive = jvalue.floatValue();
            mvalue = SimpleValueSupport.wrap(primitive);
        } else if (metaType.equals(SimpleMetaType.INTEGER)) {
            Integer jvalue = Integer.valueOf(value);
            mvalue = SimpleValueSupport.wrap(jvalue);
        } else if (metaType.equals(SimpleMetaType.INTEGER_PRIMITIVE)) {
            Integer jvalue = Integer.valueOf(value);
            int primitive = jvalue;
            mvalue = SimpleValueSupport.wrap(primitive);
        } else if (metaType.equals(SimpleMetaType.LONG)) {
            Long jvalue = Long.valueOf(value);
            mvalue = SimpleValueSupport.wrap(jvalue);
        } else if (metaType.equals(SimpleMetaType.LONG_PRIMITIVE)) {
            Long jvalue = Long.valueOf(value);
            long primitive = jvalue;
            mvalue = SimpleValueSupport.wrap(primitive);
        } else if (metaType.equals(SimpleMetaType.SHORT)) {
            Short jvalue = Short.valueOf(value);
            mvalue = SimpleValueSupport.wrap(jvalue);
        } else if (metaType.equals(SimpleMetaType.SHORT_PRIMITIVE)) {
            Short jvalue = Short.valueOf(value);
            short primitive = jvalue;
            mvalue = SimpleValueSupport.wrap(primitive);
        } else if (metaType.equals(SimpleMetaType.STRING)) {
            mvalue = SimpleValueSupport.wrap((Serializable)((Object)value));
        } else {
            throw new IllegalStateException("Unknown metaType: " + metaType);
        }
        return mvalue;
    }
}

