/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.security;

import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.jboss.logging.Logger;
import org.jboss.security.RunAs;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.identity.Identity;
import org.jboss.security.identity.plugins.SimpleIdentity;

class SecurityActions {
    private static final Logger log = Logger.getLogger(SecurityActions.class);

    SecurityActions() {
    }

    static ClassLoader getContextClassLoader() {
        return TCLAction.UTIL.getContextClassLoader();
    }

    static void setContextClassLoader(ClassLoader loader) {
        TCLAction.UTIL.setContextClassLoader(loader);
    }

    static Principal getCallerPrincipal() {
        return AccessController.doPrivileged(new PrivilegedAction<Principal>(){

            @Override
            public Principal run() {
                RunAs runas = SecurityActions.getSecurityContext().getIncomingRunAs();
                if (runas != null) {
                    return new SimplePrincipal(runas.getName());
                }
                return SecurityActions.getSecurityContext().getUtil().getUserPrincipal();
            }
        });
    }

    static Principal getPrincipal() {
        return AccessController.doPrivileged(new PrivilegedAction<Principal>(){

            @Override
            public Principal run() {
                SecurityContext sc = SecurityActions.getSecurityContext();
                return sc != null ? sc.getUtil().getUserPrincipal() : null;
            }
        });
    }

    static void setPrincipal(final Principal principal) throws PrivilegedActionException {
        AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                SimpleIdentity identity = new SimpleIdentity(principal.getName());
                SecurityContext sc = SecurityActions.getSecurityContext();
                if (sc == null) {
                    sc = SecurityActions.createSecurityContext();
                    SecurityActions.setSecurityContext(sc);
                }
                sc.getUtil().addIdentity((Identity)identity);
                return null;
            }
        });
    }

    static Object getCredential() {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SecurityContext sc = SecurityActions.getSecurityContext();
                return sc != null ? sc.getUtil().getCredential() : null;
            }
        });
    }

    static void pushSubjectContext(final Principal principal, final Object credential, final Subject subject) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SecurityContext sc = SecurityActions.getSecurityContext();
                if (sc == null) {
                    throw new RuntimeException("No Security Context");
                }
                sc.getUtil().createSubjectInfo(principal, credential, subject);
                return null;
            }
        });
    }

    static void popSubjectContext() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SecurityContext sc = SecurityActions.getSecurityContext();
                if (sc == null) {
                    throw new RuntimeException("No Security Context");
                }
                sc.setSubjectInfo(null);
                return null;
            }
        });
    }

    static RunAs peekRunAsIdentity() {
        return AccessController.doPrivileged(new PrivilegedAction<RunAs>(){

            @Override
            public RunAs run() {
                SecurityContext sc = SecurityActions.getSecurityContext();
                if (sc == null) {
                    throw new RuntimeException("No Security Context");
                }
                return sc.getIncomingRunAs();
            }
        });
    }

    static void pushRunAsIdentity(final RunAs runas) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SecurityContext sc = SecurityActions.getSecurityContext();
                if (sc == null) {
                    throw new RuntimeException("No Security Context");
                }
                sc.setIncomingRunAs(runas);
                return null;
            }
        });
    }

    static RunAs popRunAsIdentity() {
        return AccessController.doPrivileged(new PrivilegedAction<RunAs>(){

            @Override
            public RunAs run() {
                SecurityContext sc = SecurityActions.getSecurityContext();
                if (sc == null) {
                    throw new RuntimeException("No Security Context");
                }
                return sc.getIncomingRunAs();
            }
        });
    }

    static Exception getContextException() {
        return AccessController.doPrivileged(new PrivilegedAction<Exception>(){

            @Override
            public Exception run() {
                return (Exception)SecurityActions.getSecurityContext().getData().get("CONTEXTEXCEPTION");
            }
        });
    }

    static Subject getContextSubject() throws PolicyContextException {
        if (System.getSecurityManager() == null) {
            return PolicyContextActions.NON_PRIVILEGED.getContextSubject();
        }
        return PolicyContextActions.PRIVILEGED.getContextSubject();
    }

    static void clearSecurityContext() {
        ClearSecurityContextAction action = new ClearSecurityContextAction();
        AccessController.doPrivileged(action);
    }

    static SecurityContext createSecurityContext() throws PrivilegedActionException {
        return (SecurityContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return SecurityContextFactory.createSecurityContext((String)"CLIENT");
            }
        });
    }

    static SecurityContext getSecurityContext() {
        GetSecurityContextAction action = new GetSecurityContextAction();
        return (SecurityContext)AccessController.doPrivileged(action);
    }

    static void setSecurityContext(SecurityContext sc) {
        SetSecurityContextAction action = new SetSecurityContextAction(sc);
        AccessController.doPrivileged(action);
    }

    static void establishSecurityContext(String domain, Principal p, Object cred, Subject subject) throws Exception {
        SecurityContext sc = SecurityContextFactory.createSecurityContext((Principal)p, (Object)cred, (Subject)subject, (String)domain);
        SecurityActions.setSecurityContext(sc);
    }

    private static class ClearSecurityContextAction
    implements PrivilegedAction {
        ClearSecurityContextAction() {
        }

        public Object run() {
            SecurityContextAssociation.clearSecurityContext();
            return null;
        }
    }

    private static class SetSecurityContextAction
    implements PrivilegedAction {
        private SecurityContext securityContext;

        SetSecurityContextAction(SecurityContext sc) {
            this.securityContext = sc;
        }

        public Object run() {
            SecurityContextAssociation.setSecurityContext((SecurityContext)this.securityContext);
            return null;
        }
    }

    private static class GetSecurityContextAction
    implements PrivilegedAction {
        GetSecurityContextAction() {
        }

        public Object run() {
            return SecurityContextAssociation.getSecurityContext();
        }
    }

    static interface TCLAction {
        public static final TCLAction NON_PRIVILEGED = new TCLAction(){

            public ClassLoader getContextClassLoader() {
                return Thread.currentThread().getContextClassLoader();
            }

            public ClassLoader getContextClassLoader(Thread thread) {
                return thread.getContextClassLoader();
            }

            public void setContextClassLoader(ClassLoader cl) {
                Thread.currentThread().setContextClassLoader(cl);
            }

            public void setContextClassLoader(Thread thread, ClassLoader cl) {
                thread.setContextClassLoader(cl);
            }
        };
        public static final TCLAction PRIVILEGED = new TCLAction(){
            private final PrivilegedAction getTCLPrivilegedAction = new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            };

            public ClassLoader getContextClassLoader() {
                return (ClassLoader)AccessController.doPrivileged(this.getTCLPrivilegedAction);
            }

            public ClassLoader getContextClassLoader(final Thread thread) {
                return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return thread.getContextClassLoader();
                    }
                });
            }

            public void setContextClassLoader(final ClassLoader cl) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(cl);
                        return null;
                    }
                });
            }

            public void setContextClassLoader(final Thread thread, final ClassLoader cl) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        thread.setContextClassLoader(cl);
                        return null;
                    }
                });
            }
        };

        public ClassLoader getContextClassLoader();

        public ClassLoader getContextClassLoader(Thread var1);

        public void setContextClassLoader(ClassLoader var1);

        public void setContextClassLoader(Thread var1, ClassLoader var2);

        public static class UTIL {
            static TCLAction getTCLAction() {
                return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
            }

            static ClassLoader getContextClassLoader() {
                return UTIL.getTCLAction().getContextClassLoader();
            }

            static ClassLoader getContextClassLoader(Thread thread) {
                return UTIL.getTCLAction().getContextClassLoader(thread);
            }

            static void setContextClassLoader(ClassLoader cl) {
                UTIL.getTCLAction().setContextClassLoader(cl);
            }

            static void setContextClassLoader(Thread thread, ClassLoader cl) {
                UTIL.getTCLAction().setContextClassLoader(thread, cl);
            }
        }
    }

    static interface PolicyContextActions {
        public static final String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";
        public static final PolicyContextActions PRIVILEGED = new PolicyContextActions(){
            private final PrivilegedExceptionAction exAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return (Subject)PolicyContext.getContext((String)PolicyContextActions.SUBJECT_CONTEXT_KEY);
                }
            };

            public Subject getContextSubject() throws PolicyContextException {
                try {
                    return (Subject)AccessController.doPrivileged(this.exAction);
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof PolicyContextException) {
                        throw (PolicyContextException)ex;
                    }
                    throw new UndeclaredThrowableException(ex);
                }
            }
        };
        public static final PolicyContextActions NON_PRIVILEGED = new PolicyContextActions(){

            public Subject getContextSubject() throws PolicyContextException {
                return (Subject)PolicyContext.getContext((String)PolicyContextActions.SUBJECT_CONTEXT_KEY);
            }
        };

        public Subject getContextSubject() throws PolicyContextException;
    }
}

