/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.xop.jaxws;

import java.awt.Image;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataHandler;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.transform.Source;
import org.jboss.ws.extensions.xop.jaxws.AttachmentScanResult;
import org.jboss.wsf.common.JavaUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveAttachmentRefScanner {
    private static List<Class> SUPPORTED_TYPES = new ArrayList<Class>(5);
    private List<Field> scannedFields = new ArrayList<Field>();

    public AttachmentScanResult scanBean(Class xmlRoot) {
        if (ReflectiveAttachmentRefScanner.isJDKType(xmlRoot)) {
            return null;
        }
        AttachmentScanResult result = null;
        for (Field field : xmlRoot.getDeclaredFields()) {
            Class<?> type = field.getType();
            boolean exceptionToTheRule = ReflectiveAttachmentRefScanner.isAttachmentDataType(type);
            if (!exceptionToTheRule) {
                type = this.getFieldComponentType(field);
                exceptionToTheRule = ReflectiveAttachmentRefScanner.isAttachmentDataType(type);
            }
            if (this.alreadyScanned(field) || !exceptionToTheRule && ReflectiveAttachmentRefScanner.isJDKType(type)) continue;
            if (field.isAnnotationPresent(XmlAttachmentRef.class)) {
                result = new AttachmentScanResult("application/octet-stream", AttachmentScanResult.Type.SWA_REF);
            } else if (field.isAnnotationPresent(XmlMimeType.class)) {
                XmlMimeType mimeTypeDecl = field.getAnnotation(XmlMimeType.class);
                result = new AttachmentScanResult(mimeTypeDecl.value(), AttachmentScanResult.Type.XOP);
            }
            if (null == result) {
                result = ReflectiveAttachmentRefScanner.scanGetterAnnotation(xmlRoot, field);
            }
            if (!ReflectiveAttachmentRefScanner.isAttachmentDataType(type)) {
                this.scannedFields.add(field);
            }
            if (null != result) continue;
            result = this.scanBean(type);
        }
        return result;
    }

    public static List<AttachmentScanResult> scanMethod(Method method) {
        ArrayList<AttachmentScanResult> results = new ArrayList<AttachmentScanResult>();
        if (method.getReturnType() != Void.TYPE) {
            AttachmentScanResult result = null;
            if (method.isAnnotationPresent(XmlAttachmentRef.class)) {
                result = new AttachmentScanResult("application/octet-stream", AttachmentScanResult.Type.SWA_REF);
            } else if (method.isAnnotationPresent(XmlMimeType.class)) {
                XmlMimeType mimeTypeDecl = method.getAnnotation(XmlMimeType.class);
                result = new AttachmentScanResult(mimeTypeDecl.value(), AttachmentScanResult.Type.XOP);
            }
            if (result != null) {
                result.setIndex(-1);
                results.add(result);
            }
        }
        int index = 0;
        for (Annotation[] parameterAnnotations : method.getParameterAnnotations()) {
            if (parameterAnnotations != null) {
                for (Annotation annotation : parameterAnnotations) {
                    AttachmentScanResult paramResult = null;
                    if (XmlAttachmentRef.class == annotation.annotationType()) {
                        paramResult = new AttachmentScanResult("application/octet-stream", AttachmentScanResult.Type.SWA_REF);
                    } else if (XmlMimeType.class == annotation.annotationType()) {
                        XmlMimeType mimeTypeDecl = (XmlMimeType)annotation;
                        paramResult = new AttachmentScanResult(mimeTypeDecl.value(), AttachmentScanResult.Type.XOP);
                    }
                    if (paramResult == null) continue;
                    paramResult.setIndex(index);
                    results.add(paramResult);
                }
            }
            ++index;
        }
        return results;
    }

    public static AttachmentScanResult getResultByIndex(List<AttachmentScanResult> results, int index) {
        AttachmentScanResult result = null;
        for (AttachmentScanResult asr : results) {
            if (asr.getIndex() != index) continue;
            result = asr;
            break;
        }
        return result;
    }

    private boolean alreadyScanned(Field field) {
        for (Field f : this.scannedFields) {
            if (!f.equals(field)) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        this.scannedFields.clear();
    }

    private Class<?> getFieldComponentType(Field field) {
        Type[] actualTypes;
        ParameterizedType paramType;
        Class<?> fieldType = field.getType();
        if (fieldType.isArray()) {
            return fieldType.getComponentType();
        }
        if (List.class.isAssignableFrom(fieldType) && field.getGenericType() instanceof ParameterizedType && (paramType = (ParameterizedType)field.getGenericType()).getRawType() instanceof Class && List.class.isAssignableFrom((Class)paramType.getRawType()) && (actualTypes = paramType.getActualTypeArguments()).length == 1 && actualTypes[0] instanceof Class) {
            return (Class)actualTypes[0];
        }
        return fieldType;
    }

    private static boolean isAttachmentDataType(Class clazz) {
        for (Class cl : SUPPORTED_TYPES) {
            if (!JavaUtils.isAssignableFrom((Class)cl, (Class)clazz)) continue;
            return true;
        }
        return false;
    }

    private static boolean isJDKType(Class clazz) {
        return clazz.getCanonicalName().startsWith("java") || clazz.isPrimitive();
    }

    private static AttachmentScanResult scanGetterAnnotation(Class owner, Field field) {
        String getterMethodName = "get" + field.getName();
        for (Method method : owner.getDeclaredMethods()) {
            if (!method.getName().equalsIgnoreCase(getterMethodName)) continue;
            if (method.isAnnotationPresent(XmlMimeType.class)) {
                XmlMimeType mimeTypeDecl = method.getAnnotation(XmlMimeType.class);
                return new AttachmentScanResult(mimeTypeDecl.value(), AttachmentScanResult.Type.XOP);
            }
            if (!method.isAnnotationPresent(XmlAttachmentRef.class)) continue;
            return new AttachmentScanResult("application/octet-stream", AttachmentScanResult.Type.SWA_REF);
        }
        return null;
    }

    static {
        SUPPORTED_TYPES.add(String.class);
        SUPPORTED_TYPES.add(byte[].class);
        SUPPORTED_TYPES.add(Image.class);
        SUPPORTED_TYPES.add(Source.class);
        SUPPORTED_TYPES.add(DataHandler.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResultType {
        XOP,
        SWA_REF;

    }
}

