/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.vfs.helpers;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.virtual.VirtualFile;

public class LazyInputStream
extends InputStream {
    private VirtualFile file;
    private InputStream stream;

    public LazyInputStream(VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        this.file = file;
    }

    protected synchronized InputStream openStream() throws IOException {
        if (this.stream == null) {
            this.stream = this.file.openStream();
        }
        return this.stream;
    }

    public int read() throws IOException {
        return this.openStream().read();
    }

    public int read(byte[] b) throws IOException {
        return this.openStream().read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.openStream().read(b, off, len);
    }

    public long skip(long n) throws IOException {
        return this.openStream().skip(n);
    }

    public int available() throws IOException {
        return this.openStream().available();
    }

    public synchronized void close() throws IOException {
        if (this.stream == null) {
            return;
        }
        this.openStream().close();
        this.stream = null;
    }

    public void mark(int readlimit) {
        try {
            this.openStream().mark(readlimit);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void reset() throws IOException {
        this.openStream().reset();
    }

    public boolean markSupported() {
        try {
            return this.openStream().markSupported();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

