/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.graphicImage;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.jboss.seam.cache.CacheProvider;
import org.jboss.seam.ui.graphicImage.GraphicImageStore;
import org.jboss.seam.ui.graphicImage.Image;
import org.jboss.seam.ui.graphicImage.ImageTransform;
import org.jboss.seam.ui.graphicImage.UIGraphicImage;
import org.jboss.seam.ui.util.HTML;
import org.jboss.seam.ui.util.cdk.RendererBase;

public class GraphicImageRendererBase
extends RendererBase {
    protected Class getComponentClass() {
        return UIGraphicImage.class;
    }

    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        UIGraphicImage graphicImage = (UIGraphicImage)component;
        CacheProvider cacheProvider = CacheProvider.instance();
        String key = graphicImage.getFileName();
        String extension = null;
        GraphicImageStore.ImageWrapper wrapper = null;
        Image image = Image.instance();
        if (graphicImage.isInvalidate()) {
            cacheProvider.remove(graphicImage.getCacheKey());
        }
        if (graphicImage.isCache() && cacheProvider.get(graphicImage.getCacheKey()) != null) {
            wrapper = (GraphicImageStore.ImageWrapper)cacheProvider.get(graphicImage.getCacheKey());
        } else {
            image.setInput(graphicImage.getValue());
            for (UIComponent cmp : graphicImage.getChildren()) {
                if (!(cmp instanceof ImageTransform)) continue;
                ImageTransform imageTransform = (ImageTransform)cmp;
                imageTransform.applyTransform(image);
            }
            wrapper = new GraphicImageStore.ImageWrapper(image.getImage(), image.getContentType());
            if (graphicImage.isCache()) {
                cacheProvider.put(graphicImage.getCacheKey(), (Object)wrapper);
            }
        }
        key = GraphicImageStore.instance().put(wrapper, key);
        extension = image.getContentType().getExtension();
        writer.startElement("img", (UIComponent)graphicImage);
        if (graphicImage.getId() != null) {
            writer.writeAttribute("id", (Object)graphicImage.getClientId(context), "id");
        }
        String url = context.getExternalContext().getRequestContextPath() + "/seam/resource/graphicImage" + "/" + key + extension;
        writer.writeAttribute("src", (Object)url, "src");
        HTML.renderHTMLAttributes(writer, component, HTML.IMG_PASSTHROUGH_ATTRIBUTES);
        writer.endElement("img");
    }

    public boolean getRendersChildren() {
        return true;
    }
}

