/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50.invocation;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.wsf.spi.invocation.SecurityAdaptor;

public class SecurityAdaptorImpl
implements SecurityAdaptor {
    SecurityAdaptorImpl() {
    }

    public Principal getPrincipal() {
        return SecurityAssociation.getPrincipal();
    }

    public void setPrincipal(Principal pricipal) {
        SecurityAssociation.setPrincipal((Principal)pricipal);
    }

    public Object getCredential() {
        return SecurityAssociation.getCredential();
    }

    public void setCredential(Object credential) {
        SecurityAssociation.setCredential((Object)credential);
    }

    public void pushSubjectContext(Subject subject, Principal principal, Object credential) {
        SecurityAdaptorImpl.pushSubjectContext(principal, credential, subject);
    }

    private static SecurityContext getSecurityContext() {
        return (SecurityContext)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    private static void pushSubjectContext(final Principal p, final Object cred, final Subject s) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityContext sc = SecurityAdaptorImpl.getSecurityContext();
                if (sc == null) {
                    throw new IllegalStateException("Security Context is null");
                }
                sc.getUtil().createSubjectInfo(p, cred, s);
                return null;
            }
        });
    }
}

